/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.genericsystem.kernel.RemoveRestructurator;
import org.genericsystem.kernel.exceptions.AliveConstraintViolationException;
import org.genericsystem.kernel.exceptions.ConstraintViolationException;
import org.genericsystem.kernel.exceptions.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.kernel.services.BindingService;

public interface RemovableService<T extends RemovableService<T>>
extends BindingService<T> {
    public boolean isCascadeRemove(int var1);

    @Override
    public boolean isReferentialIntegrityConstraintEnabled(int var1);

    default public void remove(RemoveStrategy removeStrategy) {
        switch (removeStrategy) {
            case NORMAL: {
                this.remove();
                break;
            }
            case FORCE: {
                this.removeForce();
                break;
            }
            case CONSERVE: {
                this.removeConserve();
            }
        }
    }

    default public void remove() {
        try {
            this.getOrderedDependenciesToRemove().forEach(this::simpleRemove);
        }
        catch (ConstraintViolationException e) {
            this.rollbackAndThrowException(e);
        }
    }

    default public Iterable<T> getOrderedDependenciesToRemove() throws ConstraintViolationException {
        return this.reverseLinkedHashSet(this.buildOrderedDependenciesToRemove());
    }

    default public LinkedHashSet<T> buildOrderedDependenciesToRemove() throws ReferentialIntegrityConstraintViolationException {
        final RemovableService restructoratorService = this;
        return new LinkedHashSet<T>(){
            private static final long serialVersionUID = -3610035019789480505L;
            {
                this.visit(restructoratorService);
            }

            public void visit(T generic) throws ReferentialIntegrityConstraintViolationException {
                if (this.add(generic)) {
                    if (!generic.getInheritings().isEmpty() || !generic.getInstances().isEmpty()) {
                        throw new ReferentialIntegrityConstraintViolationException("Ancestor : " + generic + " has an inheritance or instance dependency");
                    }
                    for (RemovableService composite : generic.getComposites()) {
                        if (generic.equals(composite)) continue;
                        for (int componentPos = 0; componentPos < composite.getComponents().size(); ++componentPos) {
                            if (((RemovableService)composite.getComponents().get(componentPos)).equals(generic) || this.contains(composite) || !composite.isReferentialIntegrityConstraintEnabled(componentPos)) continue;
                            throw new ReferentialIntegrityConstraintViolationException(composite + " is Referential Integrity for ancestor " + generic + " by component position : " + componentPos);
                        }
                        this.visit(composite);
                    }
                    for (int axe = 0; axe < generic.getComponents().size(); ++axe) {
                        if (!generic.isCascadeRemove(axe)) continue;
                        this.visit((RemovableService)generic.getComponents().get(axe));
                    }
                }
            }
        };
    }

    default public Iterable<T> reverseLinkedHashSet(LinkedHashSet<T> linkedHashSet) {
        ArrayList<T> dependencies = new ArrayList<T>(linkedHashSet);
        Collections.reverse(dependencies);
        return dependencies;
    }

    default public void simpleRemove(T vertex) {
        if (!vertex.isAlive()) {
            this.rollbackAndThrowException(new AliveConstraintViolationException(vertex.info() + " is not alive"));
        }
        if (!(vertex.getInstances().isEmpty() && vertex.getInheritings().isEmpty() && vertex.getComposites().isEmpty())) {
            this.rollbackAndThrowException(new IllegalStateException(vertex.info() + " has dependencies"));
        }
        vertex.unplug();
    }

    default public void removeForce() {
        this.computeAllDependencies().forEach(x -> this.simpleRemove(x));
    }

    default public void removeConserve() {
        new RemoveRestructurator<T>(this){
            private static final long serialVersionUID = 6513791665544090616L;
        }.rebuildAll();
    }

    public static enum RemoveStrategy {
        NORMAL,
        FORCE,
        CONSERVE;

    }
}

