/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Stream;
import org.genericsystem.kernel.Root;
import org.genericsystem.kernel.annotations.Components;
import org.genericsystem.kernel.annotations.SystemGeneric;
import org.genericsystem.kernel.annotations.constraints.PropertyConstraint;
import org.genericsystem.kernel.services.CompositesInheritanceService;
import org.genericsystem.kernel.services.SystemPropertiesService;
import org.genericsystem.kernel.services.UpdatableService;

public interface MapService<T extends MapService<T>>
extends SystemPropertiesService<T>,
CompositesInheritanceService<T>,
UpdatableService<T> {
    @Override
    default public Serializable getSystemPropertyValue(Class<?> propertyClass, int pos) {
        Optional<Serializable> result;
        Optional<T> key = this.getKey(new SystemPropertiesService.AxedPropertyClass(propertyClass, pos));
        if (key.isPresent() && (result = this.getValues((CompositesInheritanceService)key.get()).stream().findFirst()).isPresent()) {
            return result.get();
        }
        return null;
    }

    @Override
    default public void setSystemPropertyValue(Class<T> propertyClass, int pos, Serializable value) {
        MapService root = (MapService)this.getRoot();
        ((MapService)root.setInstance((UpdatableService)this.getMap(), new SystemPropertiesService.AxedPropertyClass(propertyClass, pos), new MapService[]{root})).setInstance(value, new MapService[]{this});
    }

    default public T getMap() {
        return (T)((MapService)((MapService)this.getRoot()).find(SystemMap.class));
    }

    default public Stream<T> getKeys() {
        return this.getAttributes(this.getMap()).stream();
    }

    default public Optional<T> getKey(SystemPropertiesService.AxedPropertyClass property) {
        return this.getKeys().filter(x -> x.getValue().equals(property)).findFirst();
    }

    @SystemGeneric
    @Components(value={Root.class})
    @PropertyConstraint
    public static class SystemMap {
    }
}

