/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.DependenciesImpl;
import org.genericsystem.kernel.ExtendedSignature;
import org.genericsystem.kernel.Signature;
import org.genericsystem.kernel.SupersComputer;
import org.genericsystem.kernel.services.DependenciesService;

public interface FactoryService<T extends FactoryService<T>>
extends DependenciesService<T> {
    public T buildInstance();

    default public T buildInstance(List<T> overrides, Serializable value, List<T> components) {
        int level = this.getLevel() == 0 && Objects.equals(this.getValue(), ((FactoryService)this.getRoot()).getValue()) && this.getComponentsStream().allMatch(c -> c.isRoot()) && Objects.equals(value, ((FactoryService)this.getRoot()).getValue()) && components.stream().allMatch(c -> c.isRoot()) ? 0 : this.getLevel() + 1;
        overrides.forEach(x -> ((Signature)x).checkIsAlive());
        components.forEach(x -> ((Signature)x).checkIsAlive());
        ArrayList<FactoryService> supers = new ArrayList<FactoryService>(new SupersComputer<FactoryService>(level, this, overrides, value, components));
        this.checkOverridesAreReached(overrides, supers);
        return (T)((ExtendedSignature)this.buildInstance().init((FactoryService)this, supers, value, components));
    }

    default public boolean allOverridesAreReached(List<T> overrides, List<T> supers) {
        return overrides.stream().allMatch(override -> supers.stream().anyMatch(superVertex -> superVertex.inheritsFrom(override)));
    }

    default public void checkOverridesAreReached(List<T> overrides, List<T> supers) {
        if (!this.allOverridesAreReached(overrides, supers)) {
            this.rollbackAndThrowException(new IllegalStateException("Unable to reach overrides : " + overrides + " with computed supers : " + supers));
        }
    }

    public T init(T var1, List<T> var2, Serializable var3, List<T> var4);

    default public <U extends T> Dependencies<U> buildDependencies(Supplier<Iterator<T>> subDependenciesSupplier) {
        return new DependenciesImpl();
    }
}

