/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.services.AncestorsService;

public interface DisplayService<T extends DisplayService<T>>
extends AncestorsService<T> {
    default public String detailedInfo() {
        String s = "\n******************************" + System.identityHashCode(this) + "******************************\n";
        s = s + " Name        : " + this.toString() + "\n";
        s = s + " Value       : " + this.getValue() + "\n";
        s = s + " Meta        : " + this.getMeta() + " (" + System.identityHashCode(this.getMeta()) + ")\n";
        s = s + " MetaLevel   : " + Statics.getMetaLevelString(this.getLevel()) + "\n";
        s = s + " Category    : " + Statics.getCategoryString(this.getLevel(), this.getComponents().size()) + "\n";
        s = s + " Class       : " + this.getClass().getSimpleName() + "\n";
        s = s + "**********************************************************************\n";
        for (DisplayService superGeneric : this.getSupers()) {
            s = s + " Super       : " + superGeneric + " (" + System.identityHashCode(superGeneric) + ")\n";
        }
        for (DisplayService component : this.getComponents()) {
            s = s + " Component   : " + component + " (" + System.identityHashCode(component) + ")\n";
        }
        s = s + "**********************************************************************\n";
        return s;
    }

    default public String info() {
        return "(" + ((DisplayService)this.getMeta()).getValue() + ")" + this.getSupers() + "{" + this + "}" + this.getComponents() + " ";
    }

    default public void log() {
        log.info(this.detailedInfo());
    }

    default public void log(String prefix) {
        log.info(prefix + this.detailedInfo());
    }
}

