/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.services.AncestorsService;
import org.genericsystem.kernel.services.ExceptionAdviserService;
import org.genericsystem.kernel.services.SignatureService;

public interface DependenciesService<T extends DependenciesService<T>>
extends AncestorsService<T>,
ExceptionAdviserService<T> {
    public Snapshot<T> getInstances();

    public Snapshot<T> getInheritings();

    default public boolean isAncestorOf(T dependency) {
        return this.equiv((SignatureService<? extends SignatureService<?>>)dependency) || !dependency.equals(dependency.getMeta()) && this.isAncestorOf((DependenciesService)dependency.getMeta()) || dependency.getSupersStream().anyMatch(component -> this.isAncestorOf(component)) || dependency.getComponentsStream().filter(component -> !dependency.equals(component)).anyMatch(component -> this.isAncestorOf(component)) || this.inheritsFrom((DependenciesService)dependency.getMeta(), dependency.getValue(), dependency.getComponents(), (DependenciesService)this.getMeta(), this.getValue(), this.getComponents());
    }

    default public LinkedHashSet<T> computeAllDependencies() {
        class DirectDependencies
        extends LinkedHashSet<T> {
            private static final long serialVersionUID = -5970021419012502402L;
            private final Set<T> alreadyVisited = new HashSet();

            public DirectDependencies() {
                this.visit((DependenciesService)DependenciesService.this.getMeta());
            }

            public void visit(T node) {
                if (!this.alreadyVisited.contains(node)) {
                    if (!DependenciesService.this.isAncestorOf(node)) {
                        this.alreadyVisited.add(node);
                        node.getComposites().forEach(this::visit);
                        node.getInheritings().forEach(this::visit);
                        node.getInstances().forEach(this::visit);
                    } else {
                        this.addDependency(node);
                    }
                }
            }

            public void addDependency(T node) {
                if (!this.alreadyVisited.contains(node)) {
                    this.alreadyVisited.add(node);
                    node.getComposites().forEach(this::addDependency);
                    node.getInheritings().forEach(this::addDependency);
                    node.getInstances().forEach(this::addDependency);
                    super.add(node);
                }
            }
        }
        return new DirectDependencies();
    }

    default public LinkedHashSet<T> computeAllDependencies(List<T> overrides, Serializable value, List<T> components) {
        class DirectDependencies
        extends LinkedHashSet<T> {
            private static final long serialVersionUID = -5970021419012502402L;
            private final Set<T> alreadyVisited = new HashSet();

            public DirectDependencies() {
                this.visit((DependenciesService)((Object)this));
            }

            public void visit(T node) {
                if (!this.alreadyVisited.contains(node)) {
                    if (!DependenciesService.this.isAncestorOf(node)) {
                        this.alreadyVisited.add(node);
                        node.getComposites().forEach(this::visit);
                        node.getInheritings().forEach(this::visit);
                        node.getInstances().forEach(this::visit);
                    } else {
                        this.addDependency(node);
                    }
                }
            }

            public void addDependency(T node) {
                if (!this.alreadyVisited.contains(node)) {
                    this.alreadyVisited.add(node);
                    node.getComposites().forEach(this::addDependency);
                    node.getInheritings().forEach(this::addDependency);
                    node.getInstances().forEach(this::addDependency);
                    super.add(node);
                }
            }
        }
        return new DirectDependencies();
    }

    default public LinkedHashSet<T> computeDescendingDependencies() {
        class DirectDependencies
        extends LinkedHashSet<T> {
            private static final long serialVersionUID = -5970021419012502402L;
            private final Set<T> alreadyVisited = new HashSet();

            public DirectDependencies() {
                this.visit((DependenciesService)DependenciesService.this.getMeta());
            }

            public void visit(T node) {
                if (!this.alreadyVisited.contains(node)) {
                    if (!DependenciesService.this.isAncestorOf(node)) {
                        this.alreadyVisited.add(node);
                        node.getComposites().forEach(this::visit);
                        node.getInheritings().forEach(this::visit);
                        node.getInstances().forEach(this::visit);
                    } else {
                        this.addDependency(node);
                    }
                }
            }

            public void addDependency(T node) {
                if (!this.alreadyVisited.contains(node)) {
                    this.alreadyVisited.add(node);
                    node.getComposites().forEach(this::addDependency);
                    node.getInheritings().forEach(this::addDependency);
                    node.getInstances().forEach(this::addDependency);
                    super.add(node);
                }
            }
        }
        return new DirectDependencies();
    }

    public Snapshot<T> getComposites();

    default public boolean isSuperOf(T subMeta, List<T> overrides, Serializable subValue, List<T> subComponents) {
        return overrides.stream().anyMatch(override -> override.inheritsFrom(this)) || this.inheritsFrom(subMeta, subValue, subComponents, (DependenciesService)this.getMeta(), this.getValue(), this.getComponents());
    }

    default public boolean isMetaOf(T subMeta, List<T> overrides, List<T> subComponents) {
        if (!subMeta.isSpecializationOf((AncestorsService)((AncestorsService)this.getMeta()))) {
            return false;
        }
        if (!subMeta.componentsDepends(subComponents, this.getComponents())) {
            return false;
        }
        return this.getLevel() != subMeta.getLevel() || subComponents.size() != this.getComponents().size() || !subComponents.stream().allMatch(component -> component.getValue() == ((DependenciesService)this.getRoot()).getValue());
    }

    default public boolean inheritsFrom(T subMeta, Serializable subValue, List<T> subComponents, T superMeta, Serializable superValue, List<T> superComponents) {
        if (!subMeta.inheritsFrom(superMeta)) {
            return false;
        }
        if (!subMeta.componentsDepends(subComponents, superComponents)) {
            return false;
        }
        return subMeta.getValuesBiPredicate().test(subValue, superValue);
    }

    default public boolean componentsDepends(final List<T> subComponents, List<T> superComponents) {
        class SingularsLazyCacheImpl
        implements SingularsLazyCache {
            private final Boolean[] singulars;

            SingularsLazyCacheImpl() {
                this.singulars = new Boolean[subComponents.size()];
            }

            @Override
            public boolean get(int i) {
                return this.singulars[i] != null ? this.singulars[i] : Boolean.valueOf(DependenciesService.this.isSingularConstraintEnabled(i));
            }
        }
        return this.componentsDepends(new SingularsLazyCacheImpl(), subComponents, superComponents);
    }

    @Override
    public boolean isSingularConstraintEnabled(int var1);

    default public boolean componentsDepends(SingularsLazyCache singulars, List<T> subComponents, List<T> superComponents) {
        int subIndex = 0;
        block0: for (DependenciesService superComponent : superComponents) {
            while (subIndex < subComponents.size()) {
                DependenciesService subComponent = (DependenciesService)subComponents.get(subIndex);
                if (subComponent.isSpecializationOf(superComponent)) {
                    if (singulars.get(subIndex)) {
                        return true;
                    }
                    ++subIndex;
                    continue block0;
                }
                ++subIndex;
            }
            return false;
        }
        return true;
    }

    default public Stream<T> select() {
        return Stream.of(this);
    }

    default public Stream<T> getAllInheritings() {
        return Stream.concat(this.select(), Statics.concat(this.getInheritings().stream(), inheriting -> inheriting.getAllInheritings()).distinct());
    }

    default public Stream<T> getAllInstances() {
        return this.getAllInheritings().map(inheriting -> inheriting.getInstances().stream()).flatMap(x -> x);
    }

    default public Stream<T> selectInstances(Predicate<T> valuePredicate) {
        return this.getAllInstances().filter(valuePredicate);
    }

    default public Stream<T> selectInstances(Serializable value) {
        return this.selectInstances((T instance) -> Objects.equals(value, instance.getValue()));
    }

    default public Stream<T> selectInstances(Serializable value, T[] components) {
        return this.selectInstances(value, (T instance) -> this.componentsDepends(Arrays.asList(components), instance.getComponents()));
    }

    default public Stream<T> selectInstances(Serializable value, Predicate<T> componentsPredicate) {
        return this.selectInstances(value).filter(componentsPredicate);
    }

    default public Stream<T> selectInstances(Predicate<T> valuePredicate, T ... components) {
        return this.selectInstances(valuePredicate, (T instance) -> this.componentsDepends(Arrays.asList(components), instance.getComponents()));
    }

    default public Stream<T> selectInstances(Predicate<T> valuePredicate, Predicate<T> componentsPredicate) {
        return this.selectInstances(valuePredicate).filter(componentsPredicate);
    }

    default public Stream<T> selectInstances(Predicate<T> supersPredicate, Serializable value, T ... components) {
        return this.selectInstances(value, (DependenciesService[])components).filter(supersPredicate);
    }

    default public Stream<T> selectInstances(Predicate<T> supersPredicate, Serializable value, Predicate<T> componentsPredicate) {
        return this.selectInstances(value, componentsPredicate).filter(supersPredicate);
    }

    default public Stream<T> selectInstances(Predicate<T> supersPredicate, Predicate<T> valuePredicate, T ... components) {
        return this.selectInstances(valuePredicate, (DependenciesService[])components).filter(supersPredicate);
    }

    default public Stream<T> selectInstances(Predicate<T> supersPredicate, Predicate<T> valuePredicate, Predicate<T> componentsPredicate) {
        return this.selectInstances(valuePredicate, componentsPredicate).filter(supersPredicate);
    }

    default public Stream<T> selectInstances(Stream<T> supers, Serializable value, Predicate<T> componentsPredicate) {
        return this.selectInstances((T instance) -> supers.allMatch(superT -> instance.inheritsFrom(superT)), value, componentsPredicate);
    }

    default public Stream<T> selectInstances(Stream<T> supers, Predicate<T> valuePredicate, T ... components) {
        return this.selectInstances(instance -> supers.allMatch(superT -> instance.inheritsFrom(superT)), valuePredicate, (DependenciesService[])components);
    }

    default public Stream<T> selectInstances(Stream<T> supers, Predicate<T> valuePredicate, Predicate<T> componentsPredicate) {
        return this.selectInstances((T instance) -> supers.allMatch(superT -> instance.inheritsFrom(superT)), valuePredicate, componentsPredicate);
    }

    public static interface SingularsLazyCache {
        public boolean get(int var1);
    }
}

