/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.services.AncestorsService;
import org.genericsystem.kernel.services.BindingService;
import org.genericsystem.kernel.services.SignatureService;

public interface CompositesInheritanceService<T extends CompositesInheritanceService<T>>
extends BindingService<T> {
    default public Snapshot<T> getMetaAttributes(T attribute) {
        return this.getInheritings(attribute, 0);
    }

    default public Snapshot<T> getRelations() {
        return this.getRelations((CompositesInheritanceService)this.getRoot());
    }

    default public Snapshot<T> getRelations(T origin) {
        return this.getAttributes(origin).filter(attribute -> attribute.getComponents().size() > 1);
    }

    default public Snapshot<T> getAttributes(T attribute) {
        return this.getInheritings(attribute, 1);
    }

    default public Snapshot<T> getHolders(T attribute) {
        return this.getInheritings(attribute, 2);
    }

    default public Snapshot<Serializable> getValues(T attribute) {
        return () -> this.getHolders(attribute).stream().map(SignatureService::getValue).iterator();
    }

    default public Snapshot<T> getInheritings(T origin, int level) {
        return new Snapshot.AbstractSnapshot<T>((CompositesInheritanceService)origin, level){
            final /* synthetic */ CompositesInheritanceService val$origin;
            final /* synthetic */ int val$level;
            {
                this.val$origin = compositesInheritanceService;
                this.val$level = n;
            }

            @Override
            public Iterator<T> iterator() {
                return CompositesInheritanceService.this.inheritingsIterator(this.val$origin, this.val$level);
            }
        };
    }

    default public Iterator<T> inheritingsIterator(T origin, int level) {
        class Forbidden
        extends HashSet<T> {
            private static final long serialVersionUID = 1877502935577170921L;
            private final Map<T, Collection<T>> inheritings = new HashMap();
            private final T origin;
            private final int level;

            public Forbidden(T origin, int level) {
                this.origin = origin;
                this.level = level;
            }

            private Iterator<T> inheritanceIterator() {
                return this.getInheringsStream(this).iterator();
            }

            private Stream<T> getInheringsStream(T superVertex) {
                Collection result = this.inheritings.get(superVertex);
                if (result == null) {
                    result = new 1Forbidden.Inheritings(this, superVertex).inheritanceStream().collect(Collectors.toList());
                    this.inheritings.put(superVertex, result);
                }
                return result.stream();
            }

            static class 1Forbidden.Inheritings {
                private final T base;
                final /* synthetic */ Forbidden this$1;

                1Forbidden.Inheritings(T base) {
                    this.this$1 = this$1;
                    this.base = base;
                }

                private boolean isTerminal() {
                    return this.base.equals(this.this$1.this);
                }

                protected Stream<T> inheritanceStream() {
                    return this.projectStream(this.fromAboveStream());
                }

                private Stream<T> baseSupersStream() {
                    assert (this.base.getSupers() != null) : this.base.info();
                    return this.base.getSupersStream().filter(next -> this.this$1.origin.isAttributeOf(next));
                }

                private Stream<T> fromAboveStream() {
                    if (!this.this$1.origin.isAttributeOf(this.base)) {
                        return Stream.empty();
                    }
                    Stream supersStream = this.baseSupersStream();
                    if (!this.baseSupersStream().iterator().hasNext()) {
                        return this.base.isRoot() || !this.this$1.origin.isAttributeOf((AncestorsService)this.base.getMeta()) ? Stream.of(this.this$1.origin) : this.this$1.getInheringsStream((CompositesInheritanceService)this.base.getMeta());
                    }
                    return Statics.concat(supersStream, superVertex -> this.this$1.getInheringsStream(superVertex)).distinct();
                }

                protected Stream<T> projectStream(Stream<T> streamToProject) {
                    return Statics.concat(streamToProject, holder -> this.getStream(holder)).distinct();
                }

                protected Stream<T> getStream(T holder) {
                    if (holder.getLevel() != this.this$1.level || this.base.getSuperComposites(holder).iterator().hasNext()) {
                        this.this$1.add(holder);
                    }
                    Stream indexStream = Stream.concat(holder.getLevel() < this.this$1.level ? this.base.getMetaComposites(holder).stream() : Stream.empty(), this.base.getSuperComposites(holder).stream());
                    return Stream.concat(this.isTerminal() && this.this$1.contains(holder) ? Stream.empty() : Stream.of(holder), this.projectStream(indexStream));
                }
            }
        }
        return new Forbidden(origin, level).inheritanceIterator();
    }
}

