/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.exceptions.AmbiguousSelectionException;
import org.genericsystem.kernel.exceptions.CrossEnginesAssignementsException;
import org.genericsystem.kernel.exceptions.NotFoundException;
import org.genericsystem.kernel.services.DependenciesService;
import org.genericsystem.kernel.services.DisplayService;
import org.genericsystem.kernel.services.ExceptionAdviserService;
import org.genericsystem.kernel.services.FactoryService;

public interface BindingService<T extends BindingService<T>>
extends DependenciesService<T>,
FactoryService<T>,
ExceptionAdviserService<T>,
DisplayService<T> {
    default public void checkSameEngine(List<T> components) {
        if (components.stream().anyMatch(component -> !((BindingService)component.getRoot()).equals(this.getRoot()))) {
            this.rollbackAndThrowException(new CrossEnginesAssignementsException());
        }
    }

    default public T adjustMeta(List<T> overrides, Serializable subValue, List<T> subComponents) {
        BindingService result = null;
        for (BindingService directInheriting : this.getInheritings()) {
            if (!directInheriting.isMetaOf(this, overrides, subComponents)) continue;
            if (result == null) {
                result = directInheriting;
                continue;
            }
            this.rollbackAndThrowException(new AmbiguousSelectionException("Ambigous selection : " + result.info() + directInheriting.info()));
        }
        return (T)(result == null ? this : result.adjustMeta(overrides, subValue, subComponents));
    }

    default public T getInstance(Serializable value, T ... components) {
        Object nearestMeta = this.adjustMeta(Collections.emptyList(), value, Arrays.asList(components));
        if (nearestMeta != this) {
            return (T)nearestMeta.getInstance(value, components);
        }
        BindingService pluggedMeta = (BindingService)this.getAlive();
        if (pluggedMeta == null) {
            return null;
        }
        for (BindingService instance : pluggedMeta.getInstances()) {
            if (!instance.equiv(pluggedMeta, value, Arrays.asList(components))) continue;
            return (T)instance;
        }
        return null;
    }

    default public T getWeakInstance(Serializable value, T ... components) {
        Object nearestMeta = this.adjustMeta(Collections.emptyList(), value, Arrays.asList(components));
        if (nearestMeta != this) {
            return (T)nearestMeta.getInstance(value, components);
        }
        BindingService alive = (BindingService)this.getAlive();
        if (alive == null) {
            return null;
        }
        for (BindingService instance : alive.getInstances()) {
            if (!instance.weakEquiv(alive, value, Arrays.asList(components))) continue;
            return (T)instance;
        }
        return null;
    }

    default public T getInstance(List<T> supers, Serializable value, T ... components) {
        BindingService result = this.getInstance(value, (BindingService[])components);
        if (result != null && supers.stream().allMatch(superT -> result.inheritsFrom(superT))) {
            return (T)result;
        }
        return null;
    }

    public Snapshot<T> getMetaComposites(T var1);

    public Snapshot<T> getSuperComposites(T var1);

    default public T plug() {
        BindingService t = ((BindingService)this.getMeta()).indexInstance(this);
        this.getSupersStream().forEach(superGeneric -> superGeneric.indexInheriting(this));
        this.getComponentsStream().forEach(component -> component.indexByMeta((BindingService)this.getMeta(), this));
        this.getSupersStream().forEach(superGeneric -> this.getComponentsStream().forEach(component -> component.indexBySuper(superGeneric, this)));
        return (T)t;
    }

    public T indexInstance(T var1);

    public T indexInheriting(T var1);

    public T indexBySuper(T var1, T var2);

    public T indexByMeta(T var1, T var2);

    default public boolean unplug() {
        boolean result = ((BindingService)this.getMeta()).unIndexInstance(this);
        if (!result) {
            this.rollbackAndThrowException(new NotFoundException(this.info()));
        }
        this.getSupersStream().forEach(superGeneric -> superGeneric.unIndexInheriting(this));
        this.getComponentsStream().forEach(component -> component.unIndexByMeta((BindingService)this.getMeta(), this));
        this.getSupersStream().forEach(superGeneric -> this.getComponentsStream().forEach(component -> component.unIndexBySuper(superGeneric, this)));
        return result;
    }

    public boolean unIndexInstance(T var1);

    public boolean unIndexInheriting(T var1);

    public boolean unIndexBySuper(T var1, T var2);

    public boolean unIndexByMeta(T var1, T var2);
}

