/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel.services;

import java.util.List;
import java.util.stream.Stream;
import org.genericsystem.kernel.services.SignatureService;

public interface AncestorsService<T extends AncestorsService<T>>
extends SignatureService<T> {
    default public T find(Class<?> clazz) {
        return this.getRoot().find(clazz);
    }

    default public int getLevel() {
        return this.isRoot() || this.getValue().equals(this.getRoot().getValue()) || this.getComponentsStream().allMatch(c -> c.isRoot()) ? 0 : ((AncestorsService)this.getMeta()).getLevel() + 1;
    }

    default public T getRoot() {
        return ((AncestorsService)this.getMeta()).getRoot();
    }

    default public boolean isMeta() {
        return this.getLevel() == 0;
    }

    default public boolean isStructural() {
        return this.getLevel() == 1;
    }

    default public boolean isFactual() {
        return this.getLevel() == 2;
    }

    public List<T> getSupers();

    default public Stream<T> getSupersStream() {
        return this.getSupers().stream();
    }

    default public boolean inheritsFrom(T superVertex) {
        if (this == superVertex || this.equals(superVertex)) {
            return true;
        }
        if (this.getLevel() != superVertex.getLevel()) {
            return false;
        }
        return this.getSupersStream().anyMatch(vertex -> vertex.inheritsFrom(superVertex));
    }

    default public boolean isInstanceOf(T metaVertex) {
        return ((AncestorsService)this.getMeta()).inheritsFrom(metaVertex);
    }

    default public boolean isSpecializationOf(T supra) {
        return this.getLevel() == supra.getLevel() ? this.inheritsFrom(supra) : this.getLevel() > supra.getLevel() && ((AncestorsService)this.getMeta()).isSpecializationOf(supra);
    }

    default public boolean isAttributeOf(T vertex) {
        return this.isRoot() || this.getComponentsStream().anyMatch(component -> vertex.isSpecializationOf(component));
    }
}

