/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.Collections;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.DependenciesImpl;
import org.genericsystem.kernel.ExtendedSignature;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.VertexService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vertex
extends ExtendedSignature<Vertex>
implements VertexService<Vertex> {
    protected static Logger log = LoggerFactory.getLogger(Vertex.class);
    private final Dependencies<Vertex> instances = new DependenciesImpl<Vertex>();
    private final Dependencies<Vertex> inheritings = new DependenciesImpl<Vertex>();
    private final Dependencies<Dependencies.DependenciesEntry<Vertex>> superComposites = new DependenciesImpl<Dependencies.DependenciesEntry<Vertex>>();
    private final Dependencies<Dependencies.DependenciesEntry<Vertex>> metaComposites = new DependenciesImpl<Dependencies.DependenciesEntry<Vertex>>();

    @Override
    public Vertex buildInstance() {
        return new Vertex();
    }

    @Override
    public Snapshot<Vertex> getInstances() {
        return this.instances;
    }

    @Override
    public Snapshot<Vertex> getInheritings() {
        return this.inheritings;
    }

    @Override
    public Snapshot<Vertex> getComposites() {
        return () -> this.metaComposites.stream().map(entry -> ((Dependencies)entry.getValue()).stream()).flatMap(x -> x).iterator();
    }

    @Override
    public Snapshot<Vertex> getMetaComposites(Vertex meta) {
        return () -> {
            for (Dependencies.DependenciesEntry dependenciesEntry : this.metaComposites) {
                if (!meta.equals(dependenciesEntry.getKey())) continue;
                return ((Dependencies)dependenciesEntry.getValue()).iterator();
            }
            return Collections.emptyIterator();
        };
    }

    @Override
    public Snapshot<Vertex> getSuperComposites(Vertex superVertex) {
        return () -> {
            for (Dependencies.DependenciesEntry dependenciesEntry : this.superComposites) {
                if (!superVertex.equals(dependenciesEntry.getKey())) continue;
                return ((Dependencies)dependenciesEntry.getValue()).iterator();
            }
            return Collections.emptyIterator();
        };
    }

    @Override
    public Vertex indexByMeta(Vertex meta, Vertex composite) {
        return Vertex.index(this.metaComposites, meta, composite);
    }

    @Override
    public Vertex indexBySuper(Vertex superVertex, Vertex composite) {
        return Vertex.index(this.superComposites, superVertex, composite);
    }

    private static Vertex index(Dependencies<Dependencies.DependenciesEntry<Vertex>> multimap, Vertex index, Vertex composite) {
        for (Dependencies.DependenciesEntry dependenciesEntry : multimap) {
            if (!index.equals(dependenciesEntry.getKey())) continue;
            return ((Dependencies)dependenciesEntry.getValue()).set(composite);
        }
        DependenciesImpl<Vertex> dependencies = new DependenciesImpl<Vertex>();
        Vertex vertex = dependencies.set(composite);
        multimap.set(new Dependencies.DependenciesEntry<Vertex>(index, (Dependencies<Vertex>)dependencies));
        return vertex;
    }

    private static boolean unIndex(Dependencies<Dependencies.DependenciesEntry<Vertex>> multimap, Vertex index, Vertex composite) {
        for (Dependencies.DependenciesEntry dependenciesEntry : multimap) {
            if (!index.equals(dependenciesEntry.getKey())) continue;
            return ((Dependencies)dependenciesEntry.getValue()).remove(composite);
        }
        return false;
    }

    @Override
    public boolean unIndexByMeta(Vertex meta, Vertex composite) {
        return Vertex.unIndex(this.metaComposites, meta, composite);
    }

    @Override
    public boolean unIndexBySuper(Vertex superVertex, Vertex composite) {
        return Vertex.unIndex(this.superComposites, superVertex, composite);
    }

    public Vertex index(Dependencies<Vertex> dependencies, Vertex dependency) {
        return dependencies.set(dependency);
    }

    public boolean unIndex(Dependencies<Vertex> dependencies, Vertex dependency) {
        return dependencies.remove(dependency);
    }

    @Override
    public Vertex indexInstance(Vertex instance) {
        return this.index(this.instances, instance);
    }

    @Override
    public Vertex indexInheriting(Vertex inheriting) {
        return this.index(this.inheritings, inheriting);
    }

    @Override
    public boolean unIndexInstance(Vertex instance) {
        return this.unIndex(this.instances, instance);
    }

    @Override
    public boolean unIndexInheriting(Vertex inheriting) {
        return this.unIndex(this.inheritings, inheriting);
    }
}

