/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.genericsystem.kernel.services.DependenciesService;
import org.genericsystem.kernel.services.SignatureService;

public class SupersComputer<T extends DependenciesService<T>>
extends LinkedHashSet<T> {
    private static final long serialVersionUID = -1078004898524170057L;
    private final int level;
    private final T meta;
    private final List<T> overrides;
    private final List<T> components;
    private final Serializable value;
    private final Map<T, Boolean> alreadyComputed = new HashMap<T, Boolean>();

    public SupersComputer(int level, T meta, List<T> overrides, Serializable value, List<T> components) {
        this.level = level;
        this.meta = meta;
        this.overrides = overrides;
        this.components = components;
        this.value = value;
        this.visit((DependenciesService)meta.getRoot());
    }

    private boolean visit(T candidate) {
        boolean isSuper;
        Boolean result = this.alreadyComputed.get(candidate);
        if (result != null) {
            return result;
        }
        boolean isMeta = this.meta.isSpecializationOf(candidate);
        boolean bl = isSuper = !isMeta && candidate.isSuperOf(this.meta, this.overrides, this.value, this.components);
        if (!isMeta && !isSuper) {
            this.alreadyComputed.put(candidate, false);
            return false;
        }
        boolean selectable = true;
        for (DependenciesService inheriting : candidate.getInheritings()) {
            if (!this.visit(inheriting)) continue;
            selectable = false;
        }
        if (isMeta) {
            for (DependenciesService instance : candidate.getInstances()) {
                if (!this.visit(instance)) continue;
                selectable = false;
            }
        }
        result = this.alreadyComputed.put(candidate, selectable);
        assert (result == null);
        if (selectable && candidate.getLevel() == this.level && !candidate.equiv((SignatureService<?>)this.meta, this.value, (List<? extends SignatureService<?>>)this.components)) {
            this.add(candidate);
        }
        return selectable;
    }
}

