/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.genericsystem.kernel.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statics {
    private static Logger log = LoggerFactory.getLogger(Statics.class);
    private static ThreadLocal<Long> threadDebugged = new ThreadLocal();
    public static final int NO_POSITION = -1;
    public static final int BASE_POSITION = 0;
    public static final String ENGINE_VALUE = "Engine";
    public static final long MILLI_TO_NANOSECONDS = 1000000L;
    public static final int ATTEMPT_SLEEP = 15;
    public static final int ATTEMPTS = 50;
    public static final int META = 0;
    public static final int STRUCTURAL = 1;
    public static final int CONCRETE = 2;
    public static final int SENSOR = 3;
    public static final int TYPE_SIZE = 0;
    public static final int ATTRIBUTE_SIZE = 1;
    public static final int RELATION_SIZE = 2;
    public static final int TERNARY_RELATION_SIZE = 3;

    public static <T> Stream<T> concat(Stream<T>[] array) {
        return Arrays.stream(array).flatMap(x -> x);
    }

    public static <T, U> Stream<T> concat(Stream<U> stream, Function<U, Stream<T>> mappers) {
        return stream.flatMap(mappers);
    }

    public static Vertex[] insertIntoArray(Vertex generic, Vertex[] targets, int basePos) {
        if (basePos < 0 || basePos > targets.length) {
            throw new IllegalStateException("Unable to find a valid base position");
        }
        Vertex[] result = new Vertex[targets.length + 1];
        System.arraycopy(targets, 0, result, 0, basePos);
        result[basePos] = generic;
        System.arraycopy(targets, basePos, result, basePos + 1, result.length - basePos - 1);
        return result;
    }

    public static void debugCurrentThread() {
        threadDebugged.set(System.currentTimeMillis());
    }

    public static void stopDebugCurrentThread() {
        threadDebugged.remove();
    }

    public static boolean isCurrentThreadDebugged() {
        return threadDebugged.get() != null;
    }

    public static void logTimeIfCurrentThreadDebugged(String message) {
        if (Statics.isCurrentThreadDebugged()) {
            log.info(message + " : " + (System.currentTimeMillis() - threadDebugged.get()));
        }
    }

    public static String getMetaLevelString(int metaLevel) {
        switch (metaLevel) {
            case 0: {
                return "META";
            }
            case 1: {
                return "STRUCTURAL";
            }
            case 2: {
                return "CONCRETE";
            }
            case 3: {
                return "SENSOR";
            }
        }
        return "UNKNOWN";
    }

    public static String getCategoryString(int metaLevel, int dim) {
        switch (metaLevel) {
            case 0: {
                switch (dim) {
                    case 0: {
                        return "MetaType";
                    }
                    case 1: {
                        return "MetaAttribute";
                    }
                    case 2: {
                        return "MetaRelation";
                    }
                }
                return "MetaNRelation";
            }
            case 1: {
                switch (dim) {
                    case 0: {
                        return "Type";
                    }
                    case 1: {
                        return "Attribute";
                    }
                    case 2: {
                        return "Relation";
                    }
                }
                return "NRelation";
            }
            case 2: {
                switch (dim) {
                    case 0: {
                        return "Instance";
                    }
                    case 1: {
                        return "Holder";
                    }
                    case 2: {
                        return "Link";
                    }
                }
                return "NLink";
            }
        }
        return null;
    }
}

