/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.genericsystem.kernel.exceptions.NotAliveException;
import org.genericsystem.kernel.services.BindingService;
import org.genericsystem.kernel.services.DisplayService;
import org.genericsystem.kernel.services.ExceptionAdviserService;

public abstract class Signature<T extends Signature<T>>
implements DisplayService<T>,
ExceptionAdviserService<T>,
BindingService<T> {
    protected T meta;
    protected List<T> components;
    protected Serializable value;

    protected T init(T meta, Serializable value, List<T> components) {
        if (meta != null) {
            ((Signature)meta).checkIsAlive();
            this.meta = meta;
        } else {
            this.meta = this;
        }
        this.value = value;
        this.components = new ArrayList<T>(components);
        for (int i = 0; i < components.size(); ++i) {
            Signature component = (Signature)components.get(i);
            if (component != null) {
                component.checkIsAlive();
                this.components.set(i, component);
                continue;
            }
            this.components.set(i, this);
        }
        return (T)this;
    }

    public void checkIsAlive() {
        if (!this.isAlive()) {
            this.rollbackAndThrowException(new NotAliveException(this.info()));
        }
    }

    @Override
    public T getMeta() {
        return this.meta;
    }

    @Override
    public List<T> getComponents() {
        return this.components;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public Stream<T> getComponentsStream() {
        return this.components.stream();
    }

    public String toString() {
        return Objects.toString(this.getValue());
    }

    @Override
    public int getLevel() {
        return this.isRoot() || this.components.stream().allMatch(c -> c.isRoot()) && Objects.equals(this.getValue(), ((Signature)this.getRoot()).getValue()) ? 0 : ((Signature)this.meta).getLevel() + 1;
    }
}

