/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.kernel.RootService;
import org.genericsystem.kernel.Vertex;
import org.genericsystem.kernel.annotations.Components;
import org.genericsystem.kernel.annotations.Meta;
import org.genericsystem.kernel.annotations.Supers;
import org.genericsystem.kernel.annotations.SystemGeneric;
import org.genericsystem.kernel.annotations.value.BooleanValue;
import org.genericsystem.kernel.annotations.value.IntValue;
import org.genericsystem.kernel.annotations.value.StringValue;
import org.genericsystem.kernel.services.AncestorsService;
import org.genericsystem.kernel.services.MapService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Root
extends Vertex
implements RootService<Vertex> {
    protected static final Logger log = LoggerFactory.getLogger(Root.class);
    protected final Map<Class<?>, Vertex> systemCache = new HashMap();

    public Root(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Root(Serializable value, Class<?> ... userClasses) {
        this.init(null, Collections.emptyList(), value, Collections.emptyList());
        this.systemCache.put(Root.class, this);
        this.find((Class)MapService.SystemMap.class).enablePropertyConstraint();
        this.find((Class)MetaAttribute.class);
        for (Class<?> clazz : userClasses) {
            this.find((Class)clazz);
        }
    }

    @Override
    public Vertex find(Class<?> clazz) {
        Vertex result = this.systemCache.get(clazz);
        if (result == null) {
            result = (Vertex)this.findMeta(clazz).setInstance(this.findOverrides(clazz), this.findValue(clazz), this.findComponents(clazz));
            this.systemCache.put(clazz, result);
        }
        return result;
    }

    private Vertex findMeta(Class<?> clazz) {
        Meta meta = clazz.getAnnotation(Meta.class);
        return meta == null ? (Vertex)this.getRoot() : this.find((Class)meta.value());
    }

    private List<Vertex> findOverrides(Class<?> clazz) {
        ArrayList<Vertex> overridesVertices = new ArrayList<Vertex>();
        Supers supersAnnotation = clazz.getAnnotation(Supers.class);
        if (supersAnnotation != null) {
            for (Class<?> overrideClass : supersAnnotation.value()) {
                overridesVertices.add((Vertex)this.find((Class)overrideClass));
            }
        }
        return overridesVertices;
    }

    private Serializable findValue(Class<?> clazz) {
        BooleanValue booleanValue = clazz.getAnnotation(BooleanValue.class);
        if (booleanValue != null) {
            return Boolean.valueOf(booleanValue.value());
        }
        IntValue intValue = clazz.getAnnotation(IntValue.class);
        if (intValue != null) {
            return Integer.valueOf(intValue.value());
        }
        StringValue stringValue = clazz.getAnnotation(StringValue.class);
        if (stringValue != null) {
            return stringValue.value();
        }
        return clazz;
    }

    private Vertex[] findComponents(Class<?> clazz) {
        ArrayList<AncestorsService> components = new ArrayList<AncestorsService>();
        Components componentsAnnotation = clazz.getAnnotation(Components.class);
        if (componentsAnnotation != null) {
            for (Class<?> componentClass : componentsAnnotation.value()) {
                components.add(this.find((Class)componentClass));
            }
        }
        return components.toArray(new Vertex[components.size()]);
    }

    @SystemGeneric
    @Components(value={Root.class})
    @StringValue(value="Engine")
    public static class MetaAttribute {
    }
}

