/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.genericsystem.kernel.services.AncestorsService;
import org.genericsystem.kernel.services.BindingService;
import org.genericsystem.kernel.services.RemovableService;

public abstract class RemoveRestructurator<T extends RemovableService<T>>
extends HashMap<T, T> {
    private static final long serialVersionUID = -3498885981892406254L;
    private T vertexToRemove;
    private List<T> instancesOfVertexToRemove;

    private void setVertexToRemove(T vertexToRemove) {
        this.vertexToRemove = vertexToRemove;
        this.instancesOfVertexToRemove = new ArrayList<T>();
        for (RemovableService v : vertexToRemove.getInstances().stream().collect(Collectors.toList())) {
            this.instancesOfVertexToRemove.add(v);
        }
    }

    @Deprecated
    public RemoveRestructurator(T vertexToRemove) {
        assert (vertexToRemove != null);
        this.setVertexToRemove(vertexToRemove);
    }

    public void rebuildAll() {
        LinkedHashSet<RemovableService> oldDependenciesUnpluged = this.vertexToRemove.computeAllDependencies();
        oldDependenciesUnpluged.forEach(BindingService::unplug);
        oldDependenciesUnpluged.remove(this.vertexToRemove);
        this.put(this.vertexToRemove, this.vertexToRemove.getMeta());
        for (RemovableService dependency : oldDependenciesUnpluged) {
            this.getOrBuild(dependency);
        }
    }

    private T getOrBuild(T oldVertex) {
        if (oldVertex.isAlive()) {
            return oldVertex;
        }
        RemovableService newVertex = (RemovableService)this.get(oldVertex);
        if (newVertex != null) {
            return (T)newVertex;
        }
        return this.buildDependency(oldVertex);
    }

    private T buildDependency(T oldDependency) {
        RemovableService meta = this.getOrBuild((RemovableService)oldDependency.getMeta());
        Serializable value = oldDependency.getValue();
        ArrayList supers = new ArrayList();
        for (RemovableService v : oldDependency.getSupers()) {
            if (v.equals(this.vertexToRemove)) {
                for (RemovableService instance : this.instancesOfVertexToRemove) {
                    this.addThinly(this.getOrBuild(instance), supers);
                }
                continue;
            }
            this.addThinly(this.getOrBuild(v), supers);
        }
        List components = oldDependency.getComponentsStream().collect(Collectors.toList());
        if (components.isEmpty()) {
            RemovableService newDependency = (RemovableService)((RemovableService)meta.buildInstance(supers, value, components)).plug();
            this.put(oldDependency, newDependency);
            return (T)newDependency;
        }
        if (components.remove(this.vertexToRemove)) {
            for (RemovableService component : this.vertexToRemove.getInheritings()) {
                components.add(component);
                ((RemovableService)meta.buildInstance(supers, value, components)).plug();
                components.remove(component);
            }
        } else {
            return null;
        }
        return null;
    }

    private boolean addThinly(T candidate, List<T> target) {
        for (RemovableService vertex : target) {
            if (!vertex.inheritsFrom(candidate)) continue;
            return false;
        }
        Iterator<T> it = target.iterator();
        while (it.hasNext()) {
            if (!candidate.inheritsFrom((AncestorsService)((AncestorsService)it.next()))) continue;
            it.remove();
        }
        return target.add(candidate);
    }
}

