/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.kernel;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.genericsystem.kernel.Signature;

public abstract class ExtendedSignature<T extends ExtendedSignature<T>>
extends Signature<T> {
    protected List<T> supers;

    @Override
    public T init(T meta, List<T> supers, Serializable value, List<T> components) {
        super.init(meta, value, components);
        this.supers = supers;
        this.checkDependsMetaComponents();
        this.checkSupers(supers);
        this.checkDependsSuperComponents(supers);
        return (T)this;
    }

    private void checkDependsMetaComponents() {
        assert (((ExtendedSignature)this.getMeta()).getComponents() != null);
        if (!((ExtendedSignature)this.getMeta()).componentsDepends(this.getComponents(), ((ExtendedSignature)this.getMeta()).getComponents())) {
            this.rollbackAndThrowException(new IllegalStateException("Inconsistant components : " + this.getComponents() + " " + ((ExtendedSignature)this.getMeta()).getComponents()));
        }
    }

    private void checkSupers(List<T> supers) {
        supers.forEach(Signature::checkIsAlive);
        if (!supers.stream().allMatch(superVertex -> superVertex.getLevel() == this.getLevel())) {
            this.rollbackAndThrowException(new IllegalStateException("Inconsistant supers : " + this.getSupers()));
        }
        if (!supers.stream().allMatch(superVertex -> ((ExtendedSignature)this.getMeta()).inheritsFrom(superVertex.getMeta()))) {
            this.rollbackAndThrowException(new IllegalStateException("Inconsistant supers : " + this.getSupers()));
        }
        if (!supers.stream().noneMatch(this::equals)) {
            this.rollbackAndThrowException(new IllegalStateException("Supers loop detected : " + this.info()));
        }
    }

    private void checkDependsSuperComponents(List<T> supers) {
        this.getSupersStream().forEach(superVertex -> {
            if (!superVertex.isSuperOf(this.getMeta(), supers, this.getValue(), this.getComponents())) {
                this.rollbackAndThrowException(new IllegalStateException("Inconsistant components : " + this.getComponentsStream().collect(Collectors.toList())));
            }
        });
    }

    @Override
    public List<T> getSupers() {
        return this.supers;
    }
}

