/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.genericsystem.common.Root;
import org.genericsystem.cv.newmodel.FillNewModelWithData;
import org.genericsystem.ir.ActionPersistentVerticle;
import org.genericsystem.ir.DistributedVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DezonerVerticle
extends ActionPersistentVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ACTION = "dezoner";

    public DezonerVerticle(Root engine) {
        super(engine);
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected void handle(Future<Object> future, JsonObject task) {
        Path imagePath = Paths.get(DistributedVerticle.BASE_PATH + task.getString("filename"), new String[0]);
        JsonObject fields = FillNewModelWithData.detectFields((Path)imagePath);
        if (null == fields || fields.isEmpty()) {
            future.fail("No fields detected for image " + task.getString("filename"));
        } else {
            future.complete((Object)fields);
        }
    }

    @Override
    protected void handleResult(AsyncResult<Object> res, JsonObject task) {
        if (res.succeeded()) {
            this.addTask(task.getString("filename"), (JsonObject)res.result(), "annotateImage");
            this.addTask(task.getString("filename"), (JsonObject)res.result(), "ocrWorker");
        } else {
            logger.info(String.format("No zones defined for file {}.", task.getString("filename")), res.cause());
        }
    }
}

