/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.genericsystem.cv.utils.Deskewer;
import org.genericsystem.ir.ActionVerticle;
import org.genericsystem.ir.DistributedVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeskewerVerticle
extends ActionVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ACTION = "deskew";

    @Override
    public String getAction() {
        return ACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(Future<Object> future, JsonObject task) {
        Path filePath = Paths.get(DistributedVerticle.BASE_PATH + task.getString("filename"), new String[0]);
        logger.info("Deskewing image {}", (Object)filePath);
        Class<DeskewerVerticle> clazz = DeskewerVerticle.class;
        synchronized (DeskewerVerticle.class) {
            Path savedFile = Deskewer.deskewAndSave((Path)filePath, (Deskewer.METHOD)Deskewer.METHOD.ROTADED_RECTANGLES);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (savedFile != null) {
                future.complete((Object)savedFile.toString());
            } else {
                future.fail("Unable to deskew the image");
            }
            return;
        }
    }

    @Override
    protected void handleResult(AsyncResult<Object> res, JsonObject task) {
        if (!res.succeeded()) {
            throw new IllegalStateException("Error when deskewing the image " + task.getString("filename"), res.cause());
        }
        Path path = Paths.get((String)res.result(), new String[0]);
        Path relative = Paths.get(DistributedVerticle.BASE_PATH, new String[0]).relativize(path);
        this.addTask(relative.toString(), "classifyUsingFields");
    }
}

