/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ArrayBlockingQueue;
import org.genericsystem.ir.DistributedVerticle;
import org.genericsystem.ir.LocalNet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionVerticle
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ip = LocalNet.getIpAddress();

    public String getAction() {
        throw new IllegalStateException("The getAction method must be overridden by extending classes.");
    }

    public void start() throws Exception {
        this.vertx.eventBus().consumer(this.getAction(), message -> {
            JsonObject task = new JsonObject((String)message.body());
            if (DistributedVerticle.getMaxExecutions() <= DistributedVerticle.getExecutionsCount()) {
                message.fail(1, "Too many ongoing executions on " + ip);
                return;
            }
            DistributedVerticle.incrementExecutions();
            message.reply(null);
            this.vertx.executeBlocking(this.getExecuteBlockingHandler(task), res -> {
                this.handleResult((AsyncResult<Object>)res, new JsonObject(task.encode()));
                if (res.succeeded()) {
                    this.vertx.eventBus().send("org.genericsystem.repartitor:updateState", (Object)new JsonObject().put("task", task).put("newState", "finished"));
                } else {
                    this.vertx.eventBus().send("org.genericsystem.repartitor:updateState", (Object)new JsonObject().put("task", task).put("newState", "aborted"));
                    logger.error("Task {} aborted.", (Object)task, (Object)res.cause());
                }
                DistributedVerticle.decrementExecutions();
            });
        });
    }

    protected Handler<Future<Object>> getExecuteBlockingHandler(JsonObject task) {
        return future -> {
            this.download((Future<Object>)future, task);
            if (!future.failed()) {
                this.handle((Future<Object>)future, new JsonObject(task.encode()));
            }
        };
    }

    protected abstract void handle(Future<Object> var1, JsonObject var2);

    protected abstract void handleResult(AsyncResult<Object> var1, JsonObject var2);

    private void download(Future<Object> future, JsonObject task) {
        String fileName = task.getString("filename");
        File file = new File(DistributedVerticle.BASE_PATH + fileName);
        if (!file.exists()) {
            byte[] bytes;
            logger.info("Downloading file: {}", (Object)fileName);
            logger.debug("Requesting {}:8084/{}", (Object)task.getString("IP"), (Object)fileName);
            ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(1);
            HttpClient httpClient = this.vertx.createHttpClient().getNow(8084, task.getString("IP"), fileName, resp -> resp.bodyHandler(body -> {
                try {
                    blockingQueue.put(body.getBytes());
                }
                catch (InterruptedException e) {
                    future.fail((Throwable)e);
                    return;
                }
            }));
            httpClient.close();
            try {
                bytes = (byte[])blockingQueue.take();
            }
            catch (InterruptedException e) {
                future.fail((Throwable)e);
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                file.getParentFile().mkdirs();
                fos.write(bytes);
            }
            catch (IOException e) {
                future.fail((Throwable)e);
                return;
            }
            logger.debug("{} successfully downloaded ({}) ", (Object)file.getName(), (Object)String.format("%,d", file.length()));
        } else {
            logger.info("The file {} has already been downloaded.", (Object)fileName);
        }
    }

    public void addTask(String fileName, String type) {
        JsonObject task = new JsonObject().put("state", "todo").put("IP", ip).put("filename", fileName).put("type", type);
        this.vertx.eventBus().publish("org.genericsystem.repartitor:add", (Object)task.encodePrettily());
    }

    public void addTask(String fileName, JsonObject jsonObject, String type) {
        JsonObject task = new JsonObject().put("state", "todo").put("IP", ip).put("filename", fileName).put("jsonObject", jsonObject).put("type", type);
        this.vertx.eventBus().publish("org.genericsystem.repartitor:add", (Object)task.encodePrettily());
    }
}

