/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir.app.gui.utils;

import java.io.Serializable;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.EncryptionUtils;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.ContextAction;
import org.genericsystem.reactor.gscomponents.HtmlTag;
import org.genericsystem.reactor.gscomponents.Modal;
import org.genericsystem.security.model.User;

public class ContextActionCustom {

    public static class CREATE_USER_CUSTOM
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            context.mount();
            HtmlTag.HtmlInputText userNameInput = (HtmlTag.HtmlInputText)tag.getParent().getParent().find(HtmlTag.HtmlInputText.class);
            HtmlTag.HtmlInputText passwordInput = (HtmlTag.HtmlInputText)tag.getParent().getParent().find(HtmlTag.HtmlInputText.class, 1);
            HtmlTag.HtmlInputText confirmPassword = (HtmlTag.HtmlInputText)tag.getParent().getParent().find(HtmlTag.HtmlInputText.class, 2);
            HtmlTag.HtmlSpan invalidUsername = (HtmlTag.HtmlSpan)tag.getParent().getParent().find(HtmlTag.HtmlSpan.class);
            HtmlTag.HtmlSpan invalidConfirmPassword = (HtmlTag.HtmlSpan)tag.getParent().getParent().find(HtmlTag.HtmlSpan.class, 1);
            String userName = (String)userNameInput.getDomNodeAttributes(context).get((Object)"value");
            String psw1 = (String)passwordInput.getDomNodeAttributes(context).get((Object)"value");
            String psw2 = (String)confirmPassword.getDomNodeAttributes(context).get((Object)"value");
            if (userName != null) {
                Generic user;
                try {
                    user = (Generic)context.find(User.class).addInstance((Serializable)((Object)userName), (DefaultGeneric[])new Generic[0]);
                }
                catch (RollbackException e) {
                    invalidUsername.setText(context, "This username already exists");
                    invalidUsername.addStyle(context, "display", "inline");
                    invalidConfirmPassword.addStyle(context, "display", "none");
                    return;
                }
                if (psw1 != null) {
                    if (!psw1.isEmpty()) {
                        if (psw1.equals(psw2)) {
                            invalidUsername.addStyle(context, "display", "none");
                            invalidConfirmPassword.addStyle(context, "display", "none");
                            byte[] salt = EncryptionUtils.generateSalt();
                            byte[] hash = EncryptionUtils.getEncryptedPassword((String)psw1, (byte[])salt);
                            Generic hashGeneric = (Generic)user.setHolder((DefaultGeneric)context.find(User.Password.class), (Serializable)hash, (DefaultGeneric[])new Generic[0]);
                            hashGeneric.setHolder((DefaultGeneric)context.find(User.Salt.class), (Serializable)salt, (DefaultGeneric[])new Generic[0]);
                            tag.getDisplayProperty(context).setValue((Object)"none");
                            userNameInput.getDomNodeAttributes(context).put((Object)"value", (Object)"");
                            passwordInput.getDomNodeAttributes(context).put((Object)"value", (Object)"");
                            confirmPassword.getDomNodeAttributes(context).put((Object)"value", (Object)"");
                            context.flush();
                            context.unmount();
                            context.flush();
                        } else {
                            invalidConfirmPassword.setText(context, "The passwords do not match");
                            invalidUsername.addStyle(context, "display", "none");
                            invalidConfirmPassword.addStyle(context, "display", "inline");
                            context.unmount();
                        }
                    } else {
                        invalidConfirmPassword.setText(context, "Password can not be empty");
                        invalidUsername.addStyle(context, "display", "none");
                        invalidConfirmPassword.addStyle(context, "display", "inline");
                    }
                } else {
                    invalidConfirmPassword.setText(context, "Password can not be empty");
                    invalidUsername.addStyle(context, "display", "none");
                    invalidConfirmPassword.addStyle(context, "display", "inline");
                }
            } else {
                invalidUsername.setText(context, "Username can not be empty");
                invalidUsername.addStyle(context, "display", "inline");
                invalidConfirmPassword.addStyle(context, "display", "none");
            }
        }
    }

    public static class REFRESH_BEST_TEXT
    implements ContextAction {
        public void accept(Context gsContext, Tag tag) {
            System.out.println("Refreshing best text...");
            System.err.println("NOT YET IMPLEMENTED!");
        }
    }

    public static class MODAL_DISPLAY_FLEX_CUSTOM
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            Tag ancestor = tag.getParent().getParent();
            ((Modal.ModalWithDisplay)ancestor.find(Modal.ModalWithDisplay.class)).getDisplayProperty(context).setValue((Object)"flex");
        }
    }

    public static class SAVE
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            System.out.println("Saving...");
            Root root = context.getGeneric().getRoot();
            System.out.println("Current thread (save): " + Thread.currentThread().getName());
            long start = System.nanoTime();
            root.getCurrentCache().flush();
            long stop = System.nanoTime();
            System.out.println("Saved in " + (stop - start) / 1000000L + "ms");
        }
    }

    public static class REMOVE_CUSTOM
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            context.remove();
        }
    }

    public static class TEST
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            System.out.println("called from " + tag.getTag());
        }
    }

    public static class CALL_CLASSIFIER_PAGE
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            System.out.println("Redirecting to classifier page");
            tag.setInheritedContextPropertyValue("page", context, (Object)"classifierPage");
        }
    }

    public static class CALL_HOME_PAGE
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            System.out.println("Redirecting to home page");
            tag.setInheritedContextPropertyValue("page", context, (Object)"homePage");
        }
    }
}

