/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicInteger;
import org.genericsystem.ir.AnnotateImageVerticle;
import org.genericsystem.ir.ClassifierUsingFieldsVerticle;
import org.genericsystem.ir.ClassifierVerticle;
import org.genericsystem.ir.CopyToResourcesVerticle;
import org.genericsystem.ir.DeskewerVerticle;
import org.genericsystem.ir.HttpServerVerticle;
import org.genericsystem.ir.NewClassCreatorVerticle;
import org.genericsystem.ir.OcrWorkerVerticle;
import org.genericsystem.ir.PdfConverterVerticle;
import org.genericsystem.ir.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedVerticle
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String BASE_PATH = System.getenv("HOME") + "/genericsystem/gs-ir-files/";
    public static final String RESOURCES_FOLDER = System.getProperty("user.dir") + "/src/main/resources/";
    protected static final String FILENAME = "filename";
    protected static final String JSON_OBJECT = "jsonObject";
    protected static final String TYPE = "type";
    protected static final String IP = "IP";
    private static final int availProc = Runtime.getRuntime().availableProcessors();
    private static AtomicInteger currentExecutions = new AtomicInteger();

    public static void incrementExecutions() {
        currentExecutions.incrementAndGet();
    }

    public static void decrementExecutions() {
        currentExecutions.decrementAndGet();
    }

    public static int getExecutionsCount() {
        return currentExecutions.intValue();
    }

    public static int getMaxExecutions() {
        return 1;
    }

    public void start() throws Exception {
        this.vertx.deployVerticle((Verticle)new PdfConverterVerticle());
        this.vertx.deployVerticle((Verticle)new ClassifierVerticle());
        this.vertx.deployVerticle((Verticle)new OcrWorkerVerticle());
        this.vertx.deployVerticle((Verticle)new DeskewerVerticle());
        this.vertx.deployVerticle((Verticle)new ClassifierUsingFieldsVerticle());
        this.vertx.deployVerticle((Verticle)new NewClassCreatorVerticle());
        this.vertx.deployVerticle((Verticle)new CopyToResourcesVerticle());
        this.vertx.deployVerticle((Verticle)new AnnotateImageVerticle());
    }

    public static void main(String[] args) {
        DistributedVerticle verticle = new DistributedVerticle();
        verticle.doDeploy();
    }

    public void doDeploy() {
        Handler completionHandler = ar -> {
            if (ar.failed()) {
                throw new IllegalStateException(ar.cause());
            }
            logger.debug("Deployed {} DistributedVerticle", (Object)(DistributedVerticle.getMaxExecutions() < 1 ? 1 : DistributedVerticle.getMaxExecutions()));
        };
        Tools.deployOnCluster(vertx -> {
            vertx.deployVerticle((Verticle)new HttpServerVerticle(), complete -> {
                if (complete.failed()) {
                    throw new IllegalStateException(complete.cause());
                }
            });
            vertx.deployVerticle((Verticle)this, complete -> {
                if (complete.failed()) {
                    throw new IllegalStateException(complete.cause());
                }
                if (DistributedVerticle.getMaxExecutions() > 1) {
                    vertx.deployVerticle(DistributedVerticle.class.getName(), new DeploymentOptions().setInstances(DistributedVerticle.getMaxExecutions() - 1), completionHandler);
                }
            });
        });
    }

    static {
        logger.debug("Available processors: {} | BASE_PATH: {} | RESOURCES_FOLDER: {}", new Object[]{availProc, BASE_PATH, RESOURCES_FOLDER});
    }
}

