/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.genericsystem.cv.PdfToPngConverter;
import org.genericsystem.ir.ActionVerticle;
import org.genericsystem.ir.DistributedVerticle;

public class PdfConverterVerticle
extends ActionVerticle {
    public static final String ACTION = "pdfToPng";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected void handle(Future<Object> future, JsonObject task) {
        File file = new File(DistributedVerticle.BASE_PATH + task.getString("filename"));
        List createdPngs = PdfToPngConverter.convertPdfToImages((File)file, (File)new File(DistributedVerticle.BASE_PATH + "converted-png"));
        future.complete((Object)createdPngs);
    }

    @Override
    protected void handleResult(AsyncResult<Object> res, JsonObject task) {
        if (res.succeeded()) {
            for (Path newPng : (List)res.result()) {
                this.addTask(Paths.get(DistributedVerticle.BASE_PATH, new String[0]).relativize(newPng).toString(), "deskew");
            }
        } else {
            throw new IllegalStateException("An error has occured while extracting images from PDF", res.cause());
        }
    }
}

