/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.SharedData;
import java.lang.invoke.MethodHandles;
import org.genericsystem.ir.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultitonVerticle
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final String className = ((Object)((Object)this)).getClass().getSimpleName();
    protected final String startingErrorMsg = "An error has occured while deploying" + this.className;
    protected final String stoppingErrorMsg = "An error has occured while stopping" + this.className;
    protected boolean isDeployed;

    protected abstract String getCounter();

    protected abstract int getCounterOk();

    public void doDeploy() {
        Tools.deployOnCluster(vertx -> {
            SharedData sd = vertx.sharedData();
            sd.getCounter(this.getCounter(), res -> {
                if (!res.succeeded()) {
                    throw new IllegalStateException(this.startingErrorMsg, res.cause());
                }
                Counter counter = (Counter)res.result();
                logger.debug("Couter {} successfully acquired", (Object)this.getCounter());
                counter.incrementAndGet(ar -> {
                    if (!ar.succeeded()) {
                        throw new IllegalStateException(this.startingErrorMsg, res.cause());
                    }
                    long value = (Long)ar.result();
                    logger.debug("Counter {} incremented to {} (previously {})", new Object[]{this.getCounter(), value, value - 1L});
                    if (value == (long)this.getCounterOk()) {
                        logger.debug("Deploying verticle...");
                        this.deployVerticle((Vertx)vertx);
                        this.isDeployed = true;
                        logger.debug("Verticle deployed!");
                    } else {
                        logger.warn("An instance of {} is already deployed on the cluster. Aborting...", (Object)this.className);
                        counter.decrementAndGet(ar2 -> {
                            if (!ar2.succeeded()) {
                                throw new IllegalStateException(this.startingErrorMsg, res.cause());
                            }
                            long newValue = (Long)ar2.result();
                            logger.debug("Counter {} decremented to {} (previously {})", new Object[]{this.getCounter(), newValue, newValue + 1L});
                            this.undeployVerticle((Vertx)vertx);
                        });
                    }
                });
            });
        });
    }

    protected abstract void deployVerticle(Vertx var1);

    protected void undeployVerticle(Vertx vertx) {
        logger.info("Undeploying verticle...");
        vertx.close(res -> {
            if (!res.succeeded()) {
                throw new IllegalStateException("An error has occured while shutting down the verticle", res.cause());
            }
            logger.info("Undeploy successful");
        });
    }

    public void stop(Future<Void> stopFuture) throws Exception {
        if (this.isDeployed) {
            SharedData sd = this.vertx.sharedData();
            sd.getCounter(this.getCounter(), res -> {
                if (!res.succeeded()) {
                    throw new IllegalStateException(this.stoppingErrorMsg, res.cause());
                }
                Counter counter = (Counter)res.result();
                logger.debug("Couter {} successfully acquired", (Object)this.getCounter());
                counter.get(ar -> {
                    if (!ar.succeeded()) {
                        throw new IllegalStateException(this.stoppingErrorMsg, res.cause());
                    }
                    long value = (Long)ar.result();
                    logger.debug("Counter {} has value: {})", (Object)this.getCounter(), (Object)value);
                    if (value == (long)this.getCounterOk()) {
                        throw new IllegalStateException(String.format("Unexpected value (%d) for counter %s", value, this.getCounter()));
                    }
                    counter.decrementAndGet(ar2 -> {
                        if (!ar2.succeeded()) {
                            throw new IllegalStateException(this.stoppingErrorMsg, res.cause());
                        }
                        long newValue = (Long)ar2.result();
                        logger.debug("Counter {} decremented to {} (previously {})", new Object[]{this.getCounter(), newValue, newValue + 1L});
                        this.isDeployed = false;
                    });
                });
            });
        }
        super.stop(stopFuture);
    }

    public static abstract class AbstractSingletonVerticle
    extends AbstractMultitonVerticle {
        @Override
        protected int getCounterOk() {
            return 1;
        }
    }
}

