/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.ir.AbstractMultitonVerticle;
import org.genericsystem.ir.DistributedVerticle;
import org.genericsystem.ir.HttpServerVerticle;
import org.genericsystem.ir.MailWatcherVerticle;
import org.genericsystem.ir.Model;
import org.genericsystem.kernel.Cache;
import org.genericsystem.kernel.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher
extends AbstractMultitonVerticle.AbstractSingletonVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String COUNTER = Dispatcher.class.getName();
    private static final String EMAIL_SETTINGS = DistributedVerticle.BASE_PATH + "/.conf/MailWatcherVerticle.json";
    protected final Engine engine = new Engine(System.getenv("HOME") + "/genericsystem/tasks/", new Class[]{Model.Task.class});
    protected Cache cache = this.engine.newCache();
    protected final Generic taskType = this.engine.find(Model.Task.class);
    public static final String ADDRESS = "org.genericsystem.repartitor";
    protected static final String TASK = "task";
    protected static final String NEW_STATE = "newState";
    protected static final String STATE = "state";
    protected static final String TODO = "todo";
    protected static final String RUNNING = "running";
    protected static final String FINISHED = "finished";
    protected static final String ABORTED = "aborted";
    private static final long MESSAGE_SEND_PERIODICITY = 5000L;

    public static void main(String[] args) {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.doDeploy();
    }

    @Override
    protected void deployVerticle(Vertx vertx) {
        vertx.deployVerticle((Verticle)new HttpServerVerticle(), complete -> {
            if (complete.failed()) {
                throw new IllegalStateException(complete.cause());
            }
        });
        vertx.deployVerticle((Verticle)this, res -> {
            if (res.failed()) {
                throw new IllegalStateException(res.cause());
            }
        });
    }

    @Override
    protected void undeployVerticle(Vertx vertx) {
        if (this.engine != null) {
            this.engine.close();
        }
        super.undeployVerticle(vertx);
    }

    public void start(Future<Void> startFuture) throws Exception {
        this.cache.safeExecute(() -> {
            for (Generic task : this.taskType.getInstances()) {
                JsonObject json = new JsonObject((String)((Object)task.getValue()));
                if (!RUNNING.equals(json.getString(STATE))) continue;
                this.updateTaskState(json, TODO);
            }
        });
        this.watchMail();
        this.vertx.deployVerticle((Verticle)new HttpServerVerticle(), ar -> {
            if (ar.failed()) {
                throw new IllegalStateException("Unable to create HTTP server.", ar.cause());
            }
            logger.info("HTTP server started.");
        });
        this.vertx.eventBus().consumer("org.genericsystem.repartitor:watchMail", message -> {
            logger.info("Restarting mail watcher thread\u2026");
            this.watchMail();
        });
        this.vertx.eventBus().consumer("org.genericsystem.repartitor:updateState", message -> {
            JsonObject json = (JsonObject)message.body();
            this.cache.safeExecute(() -> this.updateTaskState(json.getJsonObject(TASK), json.getString(NEW_STATE)));
        });
        this.vertx.eventBus().consumer("org.genericsystem.repartitor:add", message -> this.cache.safeExecute(() -> {
            this.taskType.addInstance((Serializable)((Object)((String)message.body())), (DefaultGeneric[])new Generic[0]);
            this.cache.flush();
        }));
        this.vertx.setPeriodic(5000L, h -> this.cache.safeExecute(() -> {
            for (Generic task : this.taskType.getInstances()) {
                JsonObject json = new JsonObject((String)((Object)task.getValue()));
                if (!TODO.equals(json.getString(STATE))) continue;
                this.vertx.eventBus().send(json.getString("type"), (Object)new JsonObject(json.encode()).put(STATE, RUNNING).encodePrettily(), reply -> {
                    if (reply.failed()) {
                        switch (((ReplyException)reply.cause()).failureType()) {
                            case NO_HANDLERS: {
                                logger.warn("No handler for task: {}.", (Object)json.encodePrettily());
                                break;
                            }
                            case TIMEOUT: {
                                logger.warn("Sending of task {} timed out.", (Object)reply.cause(), (Object)json.encodePrettily());
                                break;
                            }
                            case RECIPIENT_FAILURE: {
                                logger.info("Task {} rejected by recipient.", (Object)reply.cause(), (Object)json.encodePrettily());
                            }
                        }
                    } else {
                        this.updateTaskState(json, RUNNING);
                    }
                });
            }
            this.cache.flush();
        }));
        startFuture.complete();
    }

    private void updateTaskState(JsonObject oldValue, String newState) {
        logger.debug("Updating: {}, newState: {}.", (Object)oldValue.encodePrettily(), (Object)newState);
        this.cache.safeExecute(() -> {
            Generic task = (Generic)this.taskType.getInstances().filter(g -> oldValue.equals((Object)new JsonObject((String)((Object)g.getValue())))).first();
            JsonObject newValue = new JsonObject(oldValue.encode()).put(STATE, newState);
            task.update((Serializable)((Object)newValue.encodePrettily()), (DefaultGeneric[])new Generic[0]);
            this.cache.flush();
        });
    }

    private void watchMail() {
        this.vertx.fileSystem().readFile(EMAIL_SETTINGS, ar -> {
            if (ar.failed()) {
                throw new IllegalStateException("Impossible to load configuration for MailWatcherVerticle.", ar.cause());
            }
            JsonObject config = new JsonObject((Buffer)ar.result());
            this.vertx.deployVerticle((Verticle)new MailWatcherVerticle(), new DeploymentOptions().setConfig(config), res -> {
                if (res.failed()) {
                    throw new IllegalStateException("Unable to deploy MailWatcherVerticle", res.cause());
                }
            });
        });
    }

    @Override
    protected String getCounter() {
        return COUNTER;
    }
}

