/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir.app.gui.utils;

import io.reactivex.Observable;
import java.text.Collator;
import java.util.function.Predicate;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.cv.newmodel.SimpleModel;
import org.genericsystem.reactor.context.ForEachExtractor;

public class ObservableListExtractorCustom {

    public static class DATALIST_SELECTOR
    implements ForEachExtractor {
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            SimpleModel.ZoneType.ZoneInstance zoneInstance = (SimpleModel.ZoneType.ZoneInstance)generics[1];
            SimpleModel.ImgType.ImgInstance currentImg = (SimpleModel.ImgType.ImgInstance)generics[2];
            Predicate<SimpleModel.ZoneType.ZoneInstance> filterByZone = z -> z.getZoneNum() == zoneInstance.getZoneNum() && !z.getValue().toString().isEmpty();
            Snapshot zoneInstances = currentImg.getZoneInstances();
            return Observable.just((Object)zoneInstances.filter(filterByZone).map(z -> z.getConsolidated()).sort((g1, g2) -> Collator.getInstance().compare(g1.getValue(), g2.getValue())));
        }
    }

    public static class ZONE_SELECTOR_BEST
    implements ForEachExtractor {
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            SimpleModel.ImgType.ImgInstance currentImg = (SimpleModel.ImgType.ImgInstance)generics[0];
            System.out.println("Document: " + currentImg.info());
            Snapshot zoneInstances = currentImg.getZoneInstances();
            if (zoneInstances == null) {
                return Observable.just((Object)Snapshot.empty());
            }
            return Observable.just((Object)zoneInstances.sort((g1, g2) -> Integer.compare(this.getNum((SimpleModel.ZoneType.ZoneInstance)g1), this.getNum((SimpleModel.ZoneType.ZoneInstance)g2))));
        }

        private int getNum(SimpleModel.ZoneType.ZoneInstance zoneInstance) {
            return Integer.valueOf(zoneInstance.getZoneNum().getValue().toString(), 10);
        }
    }

    public static class IMG_SELECTOR
    implements ForEachExtractor {
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            Root root = generics[0].getRoot();
            SimpleModel.ImgType imgType = (SimpleModel.ImgType)root.find(SimpleModel.ImgType.class);
            Snapshot imgInstances = imgType.getImgInstances();
            if (null == imgInstances) {
                return Observable.just((Object)Snapshot.empty());
            }
            return Observable.just((Object)imgInstances);
        }
    }

    public static class DOC_SELECTOR
    implements ForEachExtractor {
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            SimpleModel.DocClassType.DocClassInstance currentDocClass = (SimpleModel.DocClassType.DocClassInstance)generics[0];
            Snapshot docs = currentDocClass.getAllDocInstances();
            if (null == docs) {
                return Observable.just((Object)Snapshot.empty());
            }
            return Observable.just((Object)docs);
        }
    }

    public static class DOC_CLASS_SELECTOR
    implements ForEachExtractor {
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            Root root = generics[0].getRoot();
            SimpleModel.DocClassType docClass = (SimpleModel.DocClassType)root.find(SimpleModel.DocClassType.class);
            Snapshot docClassInstances = docClass.getAllDocClasses();
            if (null == docClassInstances) {
                return Observable.just((Object)Snapshot.empty());
            }
            return Observable.just((Object)docClassInstances);
        }
    }
}

