/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.genericsystem.cv.utils.NewClassCreator;
import org.genericsystem.ir.ActionVerticle;
import org.genericsystem.ir.DistributedVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewClassCreatorVerticle
extends ActionVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ACTION = "newClassCreation";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected void handle(Future<Object> future, JsonObject task) {
        Path filePath = Paths.get(DistributedVerticle.BASE_PATH + task.getString("filename"), new String[0]);
        logger.info("Creating a new class for image ", (Object)filePath);
        Path savedFile = NewClassCreator.createNewClass((Path)Paths.get(DistributedVerticle.BASE_PATH, "/classes/"), (Path)filePath);
        if (savedFile != null) {
            future.complete((Object)savedFile.toString());
        } else {
            future.fail("Unable to create the class");
        }
    }

    @Override
    protected void handleResult(AsyncResult<Object> res, JsonObject task) {
        if (!res.succeeded()) {
            throw new IllegalStateException("Error while creating a new class for image " + task.getString("filename"), res.cause());
        }
        Path path = Paths.get((String)res.result(), new String[0]);
        Path relative = Paths.get(DistributedVerticle.BASE_PATH, new String[0]).relativize(path);
        logger.info("Created new class {} for file {}", (Object)relative.getParent(), (Object)path.getFileName());
        this.addTask(relative.toString(), "newImage");
    }
}

