/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir.app.gui.pages;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.ir.app.gui.utils.ContextActionCustom;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.EncryptionUtils;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.Attribute;
import org.genericsystem.reactor.annotations.BindAction;
import org.genericsystem.reactor.annotations.BindText;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.annotations.SetText;
import org.genericsystem.reactor.annotations.Style;
import org.genericsystem.reactor.annotations.StyleClass;
import org.genericsystem.reactor.annotations.Switch;
import org.genericsystem.reactor.context.ContextAction;
import org.genericsystem.reactor.context.TagSwitcher;
import org.genericsystem.reactor.context.TextBinding;
import org.genericsystem.reactor.contextproperties.PasswordDefaults;
import org.genericsystem.reactor.contextproperties.UserRoleDefaults;
import org.genericsystem.reactor.gscomponents.FlexDirection;
import org.genericsystem.reactor.gscomponents.FlexDiv;
import org.genericsystem.reactor.gscomponents.HtmlTag;
import org.genericsystem.reactor.gscomponents.InstancesTable;
import org.genericsystem.reactor.gscomponents.Modal;
import org.genericsystem.reactor.gscomponents.Monitor;
import org.genericsystem.security.model.User;

@Children(value={LoginDiv.class, LoggedUserDiv.class})
@Switch.Modes(value={@Switch(path={LoginDiv.class}, value={TagSwitcher.NO_LOGGED_USER.class}), @Switch(path={LoggedUserDiv.class}, value={TagSwitcher.LOGGED_USER.class})})
public class HomePageUserLogin
extends FlexDiv {

    @Children.ChildrenMult(value={@Children(value={FlexDiv.class, FlexDiv.class}), @Children(path={FlexDiv.class}, pos={0}, value={HtmlTag.HtmlLabel.class}), @Children(path={FlexDiv.class}, pos={1}, value={HtmlTag.HtmlButton.class, HtmlTag.HtmlButton.class, HtmlTag.HtmlButton.class})})
    @Style.FlexDirectionStyle(value=FlexDirection.COLUMN)
    @BindText(path={FlexDiv.class, HtmlTag.HtmlLabel.class}, pos={0, 0}, value=TextBinding.LOGGED_USER.class)
    @SetText.SetTexts(value={@SetText(path={FlexDiv.class, HtmlTag.HtmlButton.class}, pos={1, 0}, value={"Logout"}), @SetText(path={FlexDiv.class, HtmlTag.HtmlButton.class}, pos={1, 1}, value={"Switch to admin mode"}), @SetText(path={FlexDiv.class, HtmlTag.HtmlButton.class}, pos={1, 2}, value={"Switch to normal mode"})})
    @BindAction.BindActions(value={@BindAction(path={FlexDiv.class, HtmlTag.HtmlButton.class}, pos={1, 0}, value={ContextAction.DISCONNECT.class}), @BindAction(path={FlexDiv.class, HtmlTag.HtmlButton.class}, pos={1, 1}, value={ContextAction.SET_ADMIN_MODE.class}), @BindAction(path={FlexDiv.class, HtmlTag.HtmlButton.class}, pos={1, 2}, value={ContextAction.SET_NORMAL_MODE.class})})
    @Switch.Modes(value={@Switch(path={FlexDiv.class, HtmlTag.HtmlButton.class}, pos={1, 1}, value={TagSwitcher.LOGGED_USER.class, TagSwitcher.NORMAL_MODE_ONLY.class}), @Switch(path={FlexDiv.class, HtmlTag.HtmlButton.class}, pos={1, 2}, value={TagSwitcher.ADMIN_MODE_ONLY.class})})
    @Style.Styles(value={@Style(path={FlexDiv.class}, name="flex", value="0"), @Style(path={FlexDiv.class}, name="align-self", value="center")})
    public static class LoggedUserDiv
    extends FlexDiv {
    }

    @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlLabel.class}, pos={0}, value={"Username:"}), @SetText(path={HtmlTag.HtmlLabel.class}, pos={1}, value={"Password:"}), @SetText(path={HtmlTag.HtmlLabel.class}, pos={2}, value={"Confirm password:"}), @SetText(path={HtmlTag.HtmlSpan.class}, pos={0}, value={"This username already exists!"}), @SetText(path={HtmlTag.HtmlSpan.class}, pos={1}, value={"These passwords don\u2019t match. Please try again."})})
    @StyleClass.StyleClasses(value={@StyleClass(path={HtmlTag.HtmlSpan.class}, value={"error-message"}), @StyleClass(path={HtmlTag.HtmlInputText.class}, value={"glowing-border"})})
    @BindAction(path={InstancesTable.ButtonDiv.class, HtmlTag.HtmlButton.class}, pos={0, 0}, value={ContextActionCustom.CREATE_USER_CUSTOM.class})
    public static class CustomUserCreation
    extends Monitor.MonitorLogin.UserCreation {
    }

    @SetText(value={"Sign up"})
    @Style(name="flex", value="1")
    @BindAction(value={ContextAction.MODAL_DISPLAY_FLEX.class})
    public static class SignUpButton
    extends HtmlTag.HtmlButton {
    }

    @SetText(value={"Sign in"})
    @Style(name="flex", value="1")
    public static class SignInButton
    extends HtmlTag.HtmlButton
    implements PasswordDefaults,
    UserRoleDefaults {
        Locale currentLocale = Locale.getDefault();
        ResourceBundle loginMessages = ResourceBundle.getBundle("UserLogin", this.currentLocale);

        public void init() {
            this.createSaltProperty();
            this.bindAction(context -> {
                Tag ancestor = this.getParent().getParent();
                HtmlTag.HtmlInputText loginInput = (HtmlTag.HtmlInputText)((FlexDiv)((InputTextUsername)ancestor.find(InputTextUsername.class)).find(FlexDiv.class)).find(HtmlTag.HtmlInputText.class);
                HtmlTag.HtmlInputText passwordInput = (HtmlTag.HtmlInputText)((FlexDiv)((InputTextPassword)ancestor.find(InputTextPassword.class)).find(FlexDiv.class)).find(HtmlTag.HtmlInputText.class);
                HtmlTag.HtmlSpan invalidLogin = (HtmlTag.HtmlSpan)((FlexDiv)((InputTextUsername)ancestor.find(InputTextUsername.class)).find(FlexDiv.class)).find(HtmlTag.HtmlSpan.class);
                HtmlTag.HtmlSpan invalidPassword = (HtmlTag.HtmlSpan)((FlexDiv)((InputTextPassword)ancestor.find(InputTextPassword.class)).find(FlexDiv.class)).find(HtmlTag.HtmlSpan.class);
                User userClass = (User)context.find(User.class);
                User.Password passwordClass = (User.Password)context.find(User.Password.class);
                User.Salt saltClass = (User.Salt)context.find(User.Salt.class);
                String loginInputValue = (String)loginInput.getDomNodeAttributes(context).get((Object)"value");
                String passwordInputValue = (String)passwordInput.getDomNodeAttributes(context).get((Object)"value");
                if (loginInputValue != null && !loginInputValue.isEmpty()) {
                    invalidLogin.addStyle(context, "display", "none");
                    if (passwordInputValue != null && !passwordInputValue.isEmpty()) {
                        invalidPassword.addStyle(context, "display", "none");
                        Generic user = (Generic)userClass.getInstance((Serializable)((Object)loginInputValue), (DefaultGeneric[])new Generic[0]);
                        System.out.println((Object)("user: " + user == null ? "null" : (loginInputValue.isEmpty() ? "empty field" : user)));
                        if (user == null) {
                            invalidLogin.setText(context, this.loginMessages.getString("user.unknown"));
                            invalidLogin.addStyle(context, "display", "inline");
                            invalidPassword.addStyle(context, "display", "none");
                            return;
                        }
                        Generic hashGeneric = (Generic)passwordClass.getInstance((DefaultGeneric[])new Generic[]{user});
                        if (hashGeneric == null) {
                            System.out.println(">>> hashGeneric == null");
                            throw new IllegalStateException("Unable to get a valid password from the database");
                        }
                        byte[] salt = (byte[])((Generic)saltClass.getInstance((DefaultGeneric[])new Generic[]{hashGeneric})).getValue();
                        if (Arrays.equals((byte[])hashGeneric.getValue(), EncryptionUtils.getEncryptedPassword((String)passwordInputValue, (byte[])salt))) {
                            loginInput.getDomNodeAttributes(context).put((Object)"value", (Object)"");
                            passwordInput.getDomNodeAttributes(context).put((Object)"value", (Object)"");
                            invalidLogin.addStyle(context, "display", "none");
                            invalidPassword.addStyle(context, "display", "none");
                            this.getLoggedUserProperty((Context)context).setValue((Object)user);
                            return;
                        }
                        invalidLogin.addStyle(context, "display", "none");
                        invalidPassword.setText(context, this.loginMessages.getString("password.invalid"));
                        invalidPassword.addStyle(context, "display", "inline");
                        return;
                    }
                    invalidPassword.setText(context, this.loginMessages.getString("password.empty"));
                    invalidPassword.addStyle(context, "display", "inline");
                    invalidLogin.addStyle(context, "display", "none");
                    return;
                }
                invalidLogin.setText(context, this.loginMessages.getString("user.empty"));
                invalidLogin.addStyle(context, "display", "inline");
                invalidPassword.addStyle(context, "display", "none");
            });
        }
    }

    @Style.FlexDirectionStyle(value=FlexDirection.ROW)
    @Children.ChildrenMult(value={@Children(value={Modal.ModalWithDisplay.class, SignInButton.class}), @Children(path={Modal.ModalWithDisplay.class, FlexDiv.class}, value={CustomUserCreation.class})})
    public static class ButtonsDiv
    extends FlexDiv {
    }

    @Style.FlexDirectionStyle.FlexDirections(value={@Style.FlexDirectionStyle(value=FlexDirection.ROW), @Style.FlexDirectionStyle(path={FlexDiv.class}, value=FlexDirection.COLUMN)})
    @Children.ChildrenMult(value={@Children(value={HtmlTag.HtmlLabel.class, FlexDiv.class}), @Children(path={FlexDiv.class}, value={HtmlTag.HtmlInputText.class, HtmlTag.HtmlSpan.class})})
    @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlLabel.class}, value={"Password"}), @SetText(path={FlexDiv.class, HtmlTag.HtmlSpan.class}, value={"Invalid password"})})
    @Style.Styles(value={@Style(path={HtmlTag.HtmlLabel.class}, name="color", value="white"), @Style(path={HtmlTag.HtmlLabel.class}, name="font-weight", value="bold"), @Style(path={FlexDiv.class, HtmlTag.HtmlSpan.class}, name="display", value="none"), @Style(path={FlexDiv.class, HtmlTag.HtmlInputText.class}, name="margin", value="0.5em")})
    @StyleClass.StyleClasses(value={@StyleClass(path={FlexDiv.class, HtmlTag.HtmlSpan.class}, value={"error-message-inv"}), @StyleClass(path={HtmlTag.HtmlLabel.class}, value={"login"}), @StyleClass(path={FlexDiv.class, HtmlTag.HtmlInputText.class}, value={"glowing-border", "login"})})
    @Attribute(path={FlexDiv.class, HtmlTag.HtmlInputText.class}, name="type", value="password")
    public static class InputTextPassword
    extends FlexDiv {
    }

    @Style.FlexDirectionStyle.FlexDirections(value={@Style.FlexDirectionStyle(value=FlexDirection.ROW), @Style.FlexDirectionStyle(path={FlexDiv.class}, value=FlexDirection.COLUMN)})
    @Children.ChildrenMult(value={@Children(value={HtmlTag.HtmlLabel.class, FlexDiv.class}), @Children(path={FlexDiv.class}, value={HtmlTag.HtmlInputText.class, HtmlTag.HtmlSpan.class})})
    @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlLabel.class}, value={"Login"}), @SetText(path={FlexDiv.class, HtmlTag.HtmlSpan.class}, value={"Invalid username"})})
    @Style.Styles(value={@Style(path={HtmlTag.HtmlLabel.class}, name="color", value="white"), @Style(path={HtmlTag.HtmlLabel.class}, name="font-weight", value="bold"), @Style(path={FlexDiv.class, HtmlTag.HtmlSpan.class}, name="display", value="none"), @Style(path={FlexDiv.class, HtmlTag.HtmlInputText.class}, name="margin", value="0.5em")})
    @StyleClass.StyleClasses(value={@StyleClass(path={FlexDiv.class, HtmlTag.HtmlSpan.class}, value={"error-message-inv"}), @StyleClass(path={HtmlTag.HtmlLabel.class}, value={"login"}), @StyleClass(path={FlexDiv.class, HtmlTag.HtmlInputText.class}, value={"glowing-border", "login"})})
    public static class InputTextUsername
    extends FlexDiv {
    }

    @Style.FlexDirectionStyle(value=FlexDirection.COLUMN)
    @Children(value={InputTextUsername.class, InputTextPassword.class, ButtonsDiv.class})
    public static class LoginDiv
    extends FlexDiv {
    }
}

