/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir.reinforcer;

import java.lang.invoke.MethodHandles;
import java.util.stream.Stream;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.Root;
import org.genericsystem.cv.newmodel.FillNewModelWithData;
import org.genericsystem.cv.newmodel.SimpleModel;
import org.genericsystem.reinforcer.Label;
import org.genericsystem.reinforcer.Labels;
import org.opencv.core.Rect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelsProvider {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String gsPath = System.getenv("HOME") + "/genericsystem/gs-cv-newmodel";
    private static final Root root = FillNewModelWithData.getEngine((String)gsPath);

    public Labels getLabels(String imgName) {
        Stream<Label> stream = this.getImgZones(imgName);
        Labels labels = new Labels();
        stream.forEach(label -> labels.addLabel(label));
        return labels;
    }

    public Stream<Label> getImgZones(String name) {
        SimpleModel.ImgType imgType = (SimpleModel.ImgType)root.find(SimpleModel.ImgType.class);
        SimpleModel.ImgType.ImgInstance imgInstance = imgType.getImg(name);
        if (imgInstance == null) {
            return Stream.empty();
        }
        Snapshot zones = imgInstance.getConsolidatedZoneInstances();
        if (zones == null) {
            return Stream.empty();
        }
        return zones.stream().map(zi -> this.getLabelFromZone((SimpleModel.ZoneType.ZoneInstance)zi));
    }

    private Label getLabelFromZone(SimpleModel.ZoneType.ZoneInstance zoneInstance) {
        Rect rect = zoneInstance.getZoneRect();
        SimpleModel.ConsolidatedType.ConsolidatedInstance ci = zoneInstance.getConsolidated();
        String consolidated = ci == null ? "" : String.valueOf(ci.getValue());
        Label label = new Label(rect.tl().x, rect.tl().y, rect.br().x, rect.br().y, consolidated);
        return label;
    }
}

