/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir.app.gui.utils;

import io.reactivex.Observable;
import java.io.Serializable;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.commons.lang3.StringEscapeUtils;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.cv.newmodel.SimpleModel;
import org.genericsystem.cv.utils.ModelTools;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.TextBinding;

public class TextBindingCustom {
    private static String getEscapedText(Serializable value) {
        return StringEscapeUtils.escapeHtml4((String)String.valueOf(value));
    }

    public static class ZONE_TEXT_REALITY
    implements TextBinding {
        public Observable<String> apply(Context context, Tag tag) {
            SimpleModel.SupervisedType.SupervisedInstance text = (SimpleModel.SupervisedType.SupervisedInstance)context.getGeneric();
            return Observable.just((Object)TextBindingCustom.getEscapedText(text.getValue()));
        }
    }

    public static class ZONE_TEXT
    implements TextBinding {
        public Observable<String> apply(Context context, Tag tag) {
            SimpleModel.ConsolidatedType.ConsolidatedInstance text = ((SimpleModel.ZoneType.ZoneInstance)context.getGeneric()).getConsolidated();
            return Observable.just((Object)TextBindingCustom.getEscapedText(text.getValue()));
        }
    }

    public static class ZONE_LABEL
    implements TextBinding {
        public Observable<String> apply(Context context, Tag tag) {
            return Observable.just((Object)("Zone " + ((SimpleModel.ZoneType.ZoneInstance)context.getGeneric()).getZoneNum().getValue()));
        }
    }

    public static class LAST_REFRESH_UPDATE_LABEL
    implements TextBinding {
        public Observable<String> apply(Context context, Tag tag) {
            SimpleModel.ImgType.ImgInstance currentImg = (SimpleModel.ImgType.ImgInstance)context.getGeneric();
            Root root = currentImg.getRoot();
            SimpleModel.ImgRefreshTimestampType refreshTimestamp = (SimpleModel.ImgRefreshTimestampType)root.find(SimpleModel.ImgRefreshTimestampType.class);
            System.out.println(refreshTimestamp.info());
            System.out.println(refreshTimestamp.getInstances((DefaultGeneric[])new Generic[]{currentImg}));
            return refreshTimestamp.getInstances((DefaultGeneric[])new Generic[]{currentImg}).getAdds().map(timeStamp -> this.formatTimeStamp((Generic)timeStamp)).startWith((Object)this.formatTimeStamp((Generic)currentImg.getImgRefreshTimestamp()));
        }

        private String formatTimeStamp(Generic timeStamp) {
            return timeStamp == null ? "Last update: none" : "Last update: " + ModelTools.formatDate((Long)((Long)timeStamp.getValue()));
        }
    }

    public static class LAST_DOC_UPDATE_LABEL
    implements TextBinding {
        public Observable<String> apply(Context context, Tag tag) {
            SimpleModel.ImgType.ImgInstance currentImg = (SimpleModel.ImgType.ImgInstance)context.getGeneric();
            SimpleObjectProperty timeStamp = new SimpleObjectProperty((Object)currentImg.getImgTimestamp());
            return Observable.just((Object)(null == timeStamp || null == timeStamp.get() ? "n/a" : ModelTools.formatDate((Long)((Long)((Generic)timeStamp.get()).getValue()))));
        }
    }
}

