/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.genericsystem.common.Root;
import org.genericsystem.cv.newmodel.FillNewModelWithData;
import org.genericsystem.ir.ActionPersistentVerticle;
import org.genericsystem.ir.DistributedVerticle;

public class AddImageToEngineVerticle
extends ActionPersistentVerticle {
    public static final String ACTION = "newImage";

    public AddImageToEngineVerticle(Root engine) {
        super(engine);
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected void handle(Future<Object> future, JsonObject task) {
        String imagePath = task.getString("filename");
        boolean result = FillNewModelWithData.registerNewFile((Root)this.engine, (Path)Paths.get(imagePath, new String[0]), (Path)Paths.get(DistributedVerticle.BASE_PATH, new String[0]), (Path)Paths.get(DistributedVerticle.RESOURCES_FOLDER, new String[0]));
        if (result) {
            future.complete();
        } else {
            future.fail(String.format("An error has occured while saving file %s in Generic System ", imagePath));
        }
    }

    @Override
    protected void handleResult(AsyncResult<Object> res, JsonObject task) {
        if (!res.succeeded()) {
            throw new IllegalStateException("An error has occurred while saving file " + task.getString("filename"), res.cause());
        }
        String filename = task.getString("filename");
        this.addTask(filename, "copyToResources");
        this.addTask(filename, "dezoner");
    }
}

