/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import org.genericsystem.common.Root;
import org.genericsystem.ir.AbstractMultitonVerticle;
import org.genericsystem.ir.AddImageToEngineVerticle;
import org.genericsystem.ir.DezonerVerticle;
import org.genericsystem.ir.HttpServerVerticle;
import org.genericsystem.ir.LinkImgToDocClassVerticle;
import org.genericsystem.ir.OcrPersistenceVerticle;

public class OcrEngineHolderVerticle
extends AbstractMultitonVerticle.AbstractSingletonVerticle {
    private final Root engine;
    private static final String COUNTER = OcrEngineHolderVerticle.class.getName();

    public OcrEngineHolderVerticle(Root engine) {
        this.engine = engine;
    }

    public void start(Future<Void> startFuture) throws Exception {
        Handler completionHandler = ar -> {
            if (ar.failed()) {
                startFuture.fail(ar.cause());
            }
        };
        this.vertx.deployVerticle((Verticle)new AddImageToEngineVerticle(this.engine), completionHandler);
        this.vertx.deployVerticle((Verticle)new DezonerVerticle(this.engine), completionHandler);
        this.vertx.deployVerticle((Verticle)new OcrPersistenceVerticle(this.engine), completionHandler);
        this.vertx.deployVerticle((Verticle)new LinkImgToDocClassVerticle(this.engine), completionHandler);
    }

    @Override
    protected void deployVerticle(Vertx vertx) {
        vertx.deployVerticle((Verticle)new HttpServerVerticle(), complete -> {
            if (complete.failed()) {
                throw new IllegalStateException(complete.cause());
            }
        });
        vertx.deployVerticle((Verticle)this, result -> {
            if (result.failed()) {
                throw new IllegalStateException("Deployment of OcrEngineHolderVerticle failed", result.cause());
            }
        });
    }

    @Override
    protected String getCounter() {
        return COUNTER;
    }
}

