/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import com.sun.mail.imap.IMAPFolder;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.internet.MimeMessage;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.commons.mail.util.MimeMessageParser;
import org.genericsystem.ir.DistributedVerticle;
import org.genericsystem.ir.LocalNet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailWatcherVerticle
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String ip = LocalNet.getIpAddress();

    public void start() throws Exception {
        this.vertx.executeBlocking(fut -> this.checkMail((Future<Object>)fut), res -> {
            if (res.failed()) {
                this.vertx.eventBus().publish("org.genericsystem.repartitor:watchMail", null);
            }
        });
    }

    private void checkMail(Future<Object> future) {
        Properties props = System.getProperties();
        Session session = Session.getInstance((Properties)props, null);
        JsonObject config = this.vertx.getOrCreateContext().config();
        URLName url = new URLName(config.getString("protocol"), config.getString("host"), config.getInteger("port").intValue(), config.getString("file"), config.getString("username"), config.getString("password"));
        IMAPFolder inbox = null;
        try {
            Store store = session.getStore(url);
            store.connect();
            inbox = (IMAPFolder)store.getFolder(url);
            inbox.open(2);
            int start = 1;
            int end = inbox.getMessageCount();
            while (start <= end) {
                Message[] msgs;
                for (Message msg : msgs = inbox.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false))) {
                    this.processMessage((MimeMessage)msg);
                }
                start = end + 1;
                end = inbox.getMessageCount();
            }
            inbox.addMessageCountListener((MessageCountListener)new MessageCountAdapter(){

                public void messagesAdded(MessageCountEvent ev) {
                    Message[] msgs;
                    for (Message msg : msgs = ev.getMessages()) {
                        MailWatcherVerticle.this.processMessage((MimeMessage)msg);
                    }
                }
            });
            while (true) {
                inbox.idle();
            }
        }
        catch (Exception e) {
            future.fail((Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processMessage(MimeMessage msg) {
        try {
            MimeMessageParser parser = new MimeMessageParser(msg).parse();
            logger.info("> New email: {}.", (Object)parser.getSubject());
            Iterator iterator = parser.getAttachmentList().iterator();
            while (iterator.hasNext()) {
                DataSource attachment = (DataSource)iterator.next();
                String contentType = attachment.getContentType().toLowerCase();
                if (!contentType.contains("application/pdf") && !contentType.contains("application/x-pdf")) continue;
                String fileName = attachment.getName();
                Path folder = Paths.get(DistributedVerticle.BASE_PATH + "downloaded-pdf/", new String[0]);
                folder.toFile().mkdirs();
                Path newFile = folder.resolve(fileName);
                Class<MailWatcherVerticle> clazz = MailWatcherVerticle.class;
                // MONITORENTER : org.genericsystem.ir.MailWatcherVerticle.class
                if (newFile.toFile().exists()) {
                    String[] fileNameParts = fileName.split("\\.(?=[^\\.]+$)");
                    newFile = File.createTempFile(fileNameParts[0] + "-", "." + fileNameParts[1], folder.toFile()).toPath();
                    newFile.toFile().delete();
                }
                Files.copy(attachment.getInputStream(), newFile, new CopyOption[0]);
                // MONITOREXIT : clazz
                JsonObject task = new JsonObject().put("state", "todo").put("IP", this.ip).put("filename", newFile.toString().replaceFirst(DistributedVerticle.BASE_PATH, "")).put("type", "pdfToPng");
                logger.info("Saved attachment: {}", (Object)task.getString("filename"));
                this.vertx.eventBus().publish("org.genericsystem.repartitor:add", (Object)task.encodePrettily());
            }
            return;
        }
        catch (Exception e) {
            logger.error("Error while processing mail.", (Throwable)e);
        }
    }
}

