/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir.app.gui.utils;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import java.lang.invoke.MethodHandles;
import org.genericsystem.common.GSVertx;
import org.genericsystem.common.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkerVerticle
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final DeploymentOptions OPTIONS_NORMAL = new DeploymentOptions();
    private static final DeploymentOptions OPTIONS_WORKER = new DeploymentOptions().setWorkerPoolName("gs-ir-worker-verticle").setWorkerPoolSize(5).setMultiThreaded(false).setMaxWorkerExecuteTime(Long.MAX_VALUE).setWorker(true);
    private final Root root;

    public WorkerVerticle() {
        this(null);
    }

    public WorkerVerticle(Root root) {
        this.root = root;
    }

    public void deployAsWorkerVerticle(String errorMessage) throws IllegalStateException {
        GSVertx.vertx().getVertx().deployVerticle((Verticle)this, OPTIONS_WORKER, res -> {
            if (res.failed()) {
                throw new IllegalStateException(errorMessage != null ? errorMessage : "Deployment of worker verticle failed.", res.cause());
            }
            this.undeployVerticle((String)res.result());
        });
    }

    private void undeployVerticle(String deploymentId) {
        this.vertx.undeploy(deploymentId, res -> {
            if (res.failed()) {
                throw new IllegalStateException("Failed to undeploy worker verticle", res.cause());
            }
        });
    }

    public void start(Future<Void> startFuture) throws Exception {
        System.out.println("Worker thread: " + Thread.currentThread().getName());
        try {
            this.start();
        }
        catch (Exception e) {
            logger.warn("An exception was caught during start. Please see the logs for details.", (Throwable)e);
        }
        startFuture.complete();
    }

    public abstract void start();
}

