/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.genericsystem.cv.Classifier;
import org.genericsystem.ir.ActionVerticle;
import org.genericsystem.ir.DistributedVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassifierVerticle
extends ActionVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ACTION = "classification";

    @Override
    public String getAction() {
        return ACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(Future<Object> future, JsonObject task) {
        Path imgPath = Paths.get(DistributedVerticle.BASE_PATH + task.getString("filename"), new String[0]);
        logger.info("Starting classification for {}", (Object)imgPath.toAbsolutePath().normalize());
        Class<ClassifierVerticle> clazz = ClassifierVerticle.class;
        synchronized (ClassifierVerticle.class) {
            Path savedFile = Classifier.classify((Path)Paths.get(DistributedVerticle.BASE_PATH + "classes/", new String[0]), (Path)imgPath);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (savedFile != null) {
                future.complete((Object)savedFile.toString());
            } else {
                future.fail("Impossible to classify image.");
            }
            return;
        }
    }

    @Override
    protected void handleResult(AsyncResult<Object> res, JsonObject task) {
        if (!res.succeeded()) {
            throw new IllegalStateException("Error when classifying the image " + task.getString("filename"), res.cause());
        }
        Path path = Paths.get((String)res.result(), new String[0]);
        Path relative = Paths.get(DistributedVerticle.BASE_PATH, new String[0]).relativize(path);
        this.addTask(relative.toString(), "newImage");
    }
}

