/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.genericsystem.cv.utils.ClassifierUsingFields;
import org.genericsystem.ir.ActionVerticle;
import org.genericsystem.ir.DistributedVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassifierUsingFieldsVerticle
extends ActionVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ERROR_MSG = "Failed to classify image";
    public static final String ACTION = "classifyUsingFields";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected void handle(Future<Object> future, JsonObject task) {
        Path filePath = Paths.get(DistributedVerticle.BASE_PATH + task.getString("filename"), new String[0]);
        logger.info("Classifying image {}", (Object)filePath);
        Path savedFile = ClassifierUsingFields.classify((Path)filePath);
        if (savedFile != null) {
            future.complete((Object)savedFile.toString());
        } else {
            future.complete((Object)ERROR_MSG);
        }
    }

    @Override
    protected void handleResult(AsyncResult<Object> res, JsonObject task) {
        if (res.succeeded()) {
            String message = (String)res.result();
            if (message == ERROR_MSG) {
                this.addTask(task.getString("filename"), "newClassCreation");
            } else {
                Path path = Paths.get(message, new String[0]);
                Path relative = Paths.get(DistributedVerticle.BASE_PATH, new String[0]).relativize(path);
                this.addTask(relative.toString(), "newImage");
            }
        } else {
            throw new IllegalStateException("Error when deskewing the image " + task.getString("filename"), res.cause());
        }
    }
}

