/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.genericsystem.cv.utils.ModelTools;
import org.genericsystem.ir.ActionVerticle;
import org.genericsystem.ir.DistributedVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyToResourcesVerticle
extends ActionVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ACTION = "copyToResources";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected void handle(Future<Object> future, JsonObject task) {
        Path filePath = Paths.get(DistributedVerticle.BASE_PATH + task.getString("filename"), new String[0]);
        String filename = ModelTools.generateFileName((Path)filePath);
        try {
            Files.copy(filePath, Paths.get(DistributedVerticle.RESOURCES_FOLDER, new String[0]).resolve(filename), StandardCopyOption.REPLACE_EXISTING);
            future.complete();
        }
        catch (IOException e) {
            future.fail((Throwable)e);
        }
    }

    @Override
    protected void handleResult(AsyncResult<Object> res, JsonObject task) {
        if (!res.succeeded()) {
            throw new IllegalStateException("Error while copying image " + task.getString("filename"), res.cause());
        }
        logger.info("Successfully copied {} to resources folder ({})", (Object)task.getString("filename"), (Object)DistributedVerticle.RESOURCES_FOLDER);
    }
}

