/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir.app.gui.utils;

import io.reactivex.Observable;
import org.genericsystem.cv.newmodel.SimpleModel;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.TagSwitcher;

public class DocPropertiesSwitcher {
    public static Observable<Boolean> isDocClassEmpty(Context context, boolean reverse) {
        SimpleModel.DocClassType.DocClassInstance currentDocClass = (SimpleModel.DocClassType.DocClassInstance)context.getGeneric();
        Observable binding = currentDocClass.getAllDocInstances().setOnChanged().map(docs -> docs.isEmpty());
        return reverse ? binding.map(bool -> bool == false) : binding;
    }

    public static Observable<Boolean> isImgDezoned(Context context, boolean reverse) {
        SimpleModel.ImgType.ImgInstance imgInstance = (SimpleModel.ImgType.ImgInstance)context.getGeneric();
        Observable binding = DocPropertiesSwitcher.getBooleanBinding(imgInstance);
        return reverse ? binding.map(bool -> bool == false) : binding;
    }

    private static Observable<Boolean> getBooleanBinding(SimpleModel.ImgType.ImgInstance imgInstance) {
        return imgInstance.getZoneInstances().setOnChanged().map(zones -> !zones.isEmpty());
    }

    public static Observable<Boolean> isDocOcrd(Context context, boolean reverse) {
        SimpleModel.ImgType.ImgInstance currentImg = (SimpleModel.ImgType.ImgInstance)context.getGeneric();
        Observable obs = currentImg.getConsolidatedZoneInstances().setOnChanged().map(zone -> !zone.isEmpty());
        return reverse ? obs.map(bool -> bool == false) : obs;
    }

    public static class DOC_NOT_OCRD
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            return DocPropertiesSwitcher.isDocOcrd(context, true);
        }
    }

    public static class DOC_OCRD
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            return DocPropertiesSwitcher.isDocOcrd(context, false);
        }
    }

    public static class DOC_NOT_DEZONED
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            return DocPropertiesSwitcher.isImgDezoned(context, true);
        }
    }

    public static class DOC_DEZONED
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            return DocPropertiesSwitcher.isImgDezoned(context, false);
        }
    }

    public static class DOC_CLASS_NOT_EMPTY
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            return DocPropertiesSwitcher.isDocClassEmpty(context, true);
        }
    }

    public static class DOC_CLASS_EMPTY
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            return DocPropertiesSwitcher.isDocClassEmpty(context, false);
        }
    }
}

