/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.ir;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.genericsystem.cv.utils.ImageAnnotator;
import org.genericsystem.ir.ActionVerticle;
import org.genericsystem.ir.DistributedVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotateImageVerticle
extends ActionVerticle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ACTION = "annotateImage";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected void handle(Future<Object> future, JsonObject task) {
        Path filePath = Paths.get(DistributedVerticle.BASE_PATH + task.getString("filename"), new String[0]);
        JsonObject fields = task.getJsonObject("jsonObject");
        Path savedPath = ImageAnnotator.annotateImage((Path)filePath, (Path)Paths.get(DistributedVerticle.RESOURCES_FOLDER, new String[0]), (JsonObject)fields);
        if (savedPath.toFile().exists()) {
            future.complete();
        } else {
            future.fail("An error has occured while saving file " + filePath.toString());
        }
    }

    @Override
    protected void handleResult(AsyncResult<Object> res, JsonObject task) {
        if (!res.succeeded()) {
            throw new IllegalStateException("Error while copying image " + task.getString("filename"), res.cause());
        }
        logger.info("Successfully copied {} to resources folder ({})", (Object)task.getString("filename"), (Object)DistributedVerticle.RESOURCES_FOLDER);
    }
}

