/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.geography.components;

import io.reactivex.Observable;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.tools.RxJavaHelpers;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.BindAction;
import org.genericsystem.reactor.annotations.BindText;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.annotations.ForEachContext;
import org.genericsystem.reactor.annotations.Style;
import org.genericsystem.reactor.annotations.StyleClass;
import org.genericsystem.reactor.context.ContextAction;
import org.genericsystem.reactor.context.ForEachExtractorFromContext;
import org.genericsystem.reactor.context.StringExtractor;
import org.genericsystem.reactor.context.TextBinding;
import org.genericsystem.reactor.gscomponents.HtmlTag;

@Children(value={SearchInput.class, SimpleBr.class, ResultUl.class})
public class InputSelectInstance
extends HtmlTag.HtmlDiv {
    public void init() {
        this.createNewContextProperty("txt");
        this.createNewContextProperty("selected");
    }

    public String displayInstance(Generic g) {
        return (String)StringExtractor.SIMPLE_CLASS_EXTRACTOR.apply((Object)g);
    }

    public Snapshot<Generic> filterInstances(Context c, Optional<String> t) {
        return c.getGeneric().getSubInstances().filter(res -> t.isPresent() && ((String)t.get()).length() > 1 ? ((String)((Object)res.getValue())).toLowerCase().startsWith(((String)t.get()).toLowerCase()) : false).sorted();
    }

    public static class TEXT_FILTERED
    implements ForEachExtractorFromContext {
        public Observable<Snapshot<Generic>> apply(Context context, Tag tag) {
            Property text = tag.getContextProperty("txt", context);
            return RxJavaHelpers.optionalValuesOf((ObservableValue)text).map(opt -> ((InputSelectInstance)tag.getParent().getParent()).filterInstances(context, (Optional<String>)opt));
        }
    }

    public static class AutocompleteAction
    implements ContextAction {
        public void accept(Context context, Tag tag) {
            ((SearchInput)tag.getParent().getParent().getParent().find(SearchInput.class)).getDomNodeAttributes(context.getParent()).put((Object)"value", (Object)((InputSelectInstance)tag.getParent().getParent().getParent()).displayInstance(context.getGeneric()));
            tag.getContextProperty("txt", context).setValue((Object)"");
            tag.getContextProperty("selected", context).setValue((Object)context.getGeneric());
        }
    }

    public static class SimpleBr
    extends HtmlTag.HtmlBr {
    }

    public static class DEFAULT_TEXT
    implements TextBinding {
        public Observable<String> apply(Context context, Tag tag) {
            String str = "";
            if (tag.getContextProperty("selected", context).getValue() != null) {
                str = ((InputSelectInstance)tag.getParent()).displayInstance((Generic)tag.getContextProperty("selected", context).getValue());
            }
            return Observable.just((Object)str);
        }
    }

    @BindText(value=DEFAULT_TEXT.class)
    public static class SearchInput
    extends HtmlTag.HtmlInputText {
        public void init() {
            this.addPrefixBinding(context -> this.getDomNodeAttributes((Context)context).addListener(change -> {
                if ("value".equals(change.getKey()) && change.wasAdded()) {
                    this.getContextProperty("txt", (Context)context).setValue(change.getValueAdded());
                }
            }));
        }
    }

    public static class GENERIC_TEXT
    implements TextBinding {
        public Observable<String> apply(Context context, Tag tag) {
            return Observable.just((Object)((InputSelectInstance)tag.getParent().getParent().getParent()).displayInstance(context.getGeneric()));
        }
    }

    @BindText(value=GENERIC_TEXT.class)
    @Style.Styles(value={@Style(name="display", value="block"), @Style(name="text-decoration", value="none"), @Style(name="padding-left", value="10px"), @Style(name="padding-right", value="10px"), @Style(name="color", value="black")})
    @BindAction(value={AutocompleteAction.class})
    public static class ResultLink
    extends HtmlTag.HtmlHyperLink {
    }

    @ForEachContext(value=TEXT_FILTERED.class)
    @Children(value={ResultLink.class})
    @Style(name="background-color", value="1.4em")
    @StyleClass(value={"autocomplete"})
    public static class ResultLi
    extends HtmlTag.HtmlLi {
    }

    @Children(value={ResultLi.class})
    @Style.Styles(value={@Style(name="margin-top", value="0"), @Style(name="background-color", value="#fff"), @Style(name="display", value="inline-block"), @Style(name="list-style-type", value="none"), @Style(name="position", value="absolute"), @Style(name="z-index", value="200"), @Style(name="padding-left", value="0")})
    public static class ResultUl
    extends HtmlTag.HtmlUl {
    }
}

