/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.geography.app;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.geography.model.AdministrativeTerritory;
import org.genericsystem.geography.model.Building;
import org.genericsystem.geography.model.City;
import org.genericsystem.geography.model.Country;
import org.genericsystem.geography.model.Place;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.annotations.DependsOnModel;
import org.genericsystem.reactor.annotations.DirectSelect;
import org.genericsystem.reactor.annotations.RunScript;
import org.genericsystem.reactor.annotations.Style;
import org.genericsystem.reactor.appserver.ApplicationServer;
import org.genericsystem.reactor.appserver.Script;
import org.genericsystem.reactor.gscomponents.AppHeader;
import org.genericsystem.reactor.gscomponents.DivWithTitle;
import org.genericsystem.reactor.gscomponents.Modal;
import org.genericsystem.reactor.gscomponents.Monitor;
import org.genericsystem.reactor.gscomponents.Responsive;
import org.genericsystem.reactor.gscomponents.RootTagImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunScript(value=GeoScript.class)
@DependsOnModel(value={AdministrativeTerritory.class, Country.class, Place.class, City.class, Building.class})
@Style(name="background-color", value="#00afeb")
@Children.ChildrenMult(value={@Children(value={Modal.ModalEditor.class, AppHeader.class, Responsive.class, Monitor.class}), @Children(path={Responsive.class}, value={DivWithTitle.TitledInstancesTable.class, DivWithTitle.TitledInstancesTable.class, DivWithTitle.TitledInstancesTable.class, DivWithTitle.TitledInstancesTable.class, DivWithTitle.TitledInstancesTable.class})})
@DirectSelect(path={Responsive.class, DivWithTitle.TitledInstancesTable.class}, value={Country.class, AdministrativeTerritory.Adm1.class, AdministrativeTerritory.Adm2.class, AdministrativeTerritory.Adm3.class, City.class})
public class GeoStore
extends RootTagImpl {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static HashMap<String, Generic> hm;

    public static void main(String[] mainArgs) {
        ApplicationServer.startSimpleGenericApp((String[])mainArgs, GeoStore.class, (String)"/GeoApp");
    }

    public static void readFile(String filename, Root engine, Generic returnType, int n) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                GeoStore.readLine(line, engine, returnType, n);
            }
            reader.close();
        }
        catch (Exception e) {
            logger.warn("Exception while reading file {}.", (Object)filename, (Object)e);
        }
        engine.getCurrentCache().flush();
    }

    public static String componentCode(String[] parts, int n) {
        String code = parts[0];
        for (int i = 1; i < n - 1; ++i) {
            code = code + "_" + parts[i];
        }
        return code;
    }

    public static void readLine(String line, Root engine, Generic returnType, int n) {
        String[] parts = line.split("\\|");
        if ("FR".equals(parts[0])) {
            System.out.println("@" + line);
            if (returnType.getBaseComponent() == null) {
                String currentCode = parts[parts.length - 2];
                Generic currentInstance = (Generic)returnType.addInstance((Serializable)((Object)parts[n]), (DefaultGeneric[])new Generic[0]);
                hm.put(currentCode, currentInstance);
            } else {
                String componentCode = GeoStore.componentCode(parts, n);
                String currentCode = componentCode + "_" + parts[n - 1];
                Generic componentInstance = hm.get(componentCode);
                if (componentInstance != null) {
                    if (returnType == engine.find(City.class)) {
                        if ("44".equals(parts[2])) {
                            Generic currentInstance = engine.getCurrentCache().buildAndPlug(null, returnType, Collections.emptyList(), (Serializable)((Object)parts[n - 1]), Collections.singletonList(componentInstance));
                            Generic latInstance = engine.getCurrentCache().buildAndPlug(null, engine.find(Place.Latitude.class), Collections.emptyList(), (Serializable)Double.valueOf(parts[n]), Collections.singletonList(currentInstance));
                            Generic lonInstance = engine.getCurrentCache().buildAndPlug(null, engine.find(Place.Longitude.class), Collections.emptyList(), (Serializable)Double.valueOf(parts[n + 1]), Collections.singletonList(currentInstance));
                            hm.put(currentCode, currentInstance);
                        }
                    } else {
                        String currentValue = parts[n];
                        Generic currentInstance = engine.getCurrentCache().buildAndPlug(null, returnType, Collections.emptyList(), (Serializable)((Object)parts[n]), Collections.singletonList(componentInstance));
                        hm.put(currentCode, currentInstance);
                    }
                }
            }
        }
    }

    public static class GeoScript
    implements Script {
        public void run(Root engine) {
            hm = new HashMap();
            GeoStore.readFile("src/main/resources/countries.csv", engine, engine.find(Country.class), 1);
            GeoStore.readFile("src/main/resources/adm1.csv", engine, engine.find(AdministrativeTerritory.Adm1.class), 2);
            GeoStore.readFile("src/main/resources/adm2.csv", engine, engine.find(AdministrativeTerritory.Adm2.class), 3);
            GeoStore.readFile("src/main/resources/adm3.csv", engine, engine.find(AdministrativeTerritory.Adm3.class), 4);
            GeoStore.readFile("src/main/resources/populated_fr.csv", engine, engine.find(City.class), 5);
        }
    }
}

