/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.examplejavafx;

import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;

public class EditingCell<S, T>
extends TableCell<S, T> {
    private final TextField textField;
    private StringConverter<T> converter;

    public EditingCell(final StringConverter<T> converter) {
        this.converter = converter;
        this.textField = new TextField(converter.toString(this.getItem()));
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && EditingCell.this.textField != null) {
                    System.out.println("coucou lost focus : " + EditingCell.this.textField.getText());
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditingCell.this.commitEdit(converter.fromString(EditingCell.this.textField.getText()));
                        }
                    });
                }
            }
        });
        this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    EditingCell.this.commitEdit(converter.fromString(EditingCell.this.textField.getText()));
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCell.this.cancelEdit();
                }
            }
        });
    }

    public void startEdit() {
        super.startEdit();
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EditingCell.this.textField.requestFocus();
                EditingCell.this.textField.selectAll();
            }
        });
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.converter.toString(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.converter.toString(this.getItem()));
            }
            this.setGraphic((Node)this.textField);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        } else {
            this.setText(this.converter.toString(this.getItem()));
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }
    }

    public void commitEdit(T item) {
        TableView table;
        if (!this.isEditing() && !Objects.equals(item, this.getItem()) && (table = this.getTableView()) != null) {
            TableColumn column = this.getTableColumn();
            TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), column), TableColumn.editCommitEvent(), item);
            Event.fireEvent((EventTarget)column, (Event)event);
        }
        super.commitEdit(item);
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }
}

