/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.examplejavafx;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.genericsystem.common.Generic;
import org.genericsystem.examplejavafx.EditingCell;

public class AbstractColumn<T>
extends TableColumn<Generic, T> {
    protected final Observables<T> observables = new Observables();

    public AbstractColumn(Generic generic, String columnName, Function<Generic, T> getter, BiConsumer<Generic, T> setter) {
        super(columnName);
        this.setMinWidth(200.0);
        this.setCellValueFactory(cellData -> this.observables.get(cellData.getValue(), getter.apply((Generic)cellData.getValue())));
        this.setOnEditCommit(t -> {
            System.out.println("coucou");
            Generic g = (Generic)t.getTableView().getItems().get(t.getTablePosition().getRow());
            setter.accept(g, t.getNewValue());
            ((SimpleObjectProperty)this.observables.get(g)).set(t.getNewValue());
        });
        this.setEditable(true);
    }

    static <T> StringConverter<T> getDefaultConverter(Class<T> clazz) {
        if (Integer.class.equals(clazz)) {
            return new IntegerStringConverter();
        }
        return new DefaultStringConverter();
    }

    static class GenericStringConverter<T extends Serializable>
    extends StringConverter<Generic> {
        private final StringConverter<T> instanceValueClassConverter;

        GenericStringConverter(Generic component) {
            this.instanceValueClassConverter = AbstractColumn.getDefaultConverter(component.getInstanceValueClassConstraint());
        }

        public String toString(Generic generic) {
            return this.instanceValueClassConverter.toString((Object)generic.getValue());
        }

        public Generic fromString(String string) {
            throw new IllegalStateException();
        }
    }

    public static class Observables<T>
    extends HashMap<Generic, SimpleObjectProperty<T>> {
        private static final long serialVersionUID = 7709729724315030415L;

        public ObservableValue<T> get(Object key, T value) {
            SimpleObjectProperty observable = (SimpleObjectProperty)super.get(key);
            if (observable == null) {
                observable = new SimpleObjectProperty(value);
                this.put((Generic)key, observable);
            }
            return observable;
        }
    }

    public static class TargetComponentColumn
    extends AbstractColumn<Generic> {
        public TargetComponentColumn(Generic targetComponent, String columnName, Function<Generic, Generic> getter, BiConsumer<Generic, Generic> setter) {
            super(targetComponent, columnName, getter, setter);
            this.setCellFactory(tableColumn -> new ComboBoxTableCell(new GenericStringConverter(targetComponent), FXCollections.observableArrayList((Collection)targetComponent.getSubInstances().toList())));
        }
    }

    public static class GenericColumn<T>
    extends AbstractColumn<T> {
        public GenericColumn(Generic attribute, String columnName, Function<Generic, T> getter, BiConsumer<Generic, T> setter) {
            super(attribute, columnName, getter, setter);
            this.setCellFactory(tableColumn -> new EditingCell(GenericColumn.getDefaultConverter(attribute.getInstanceValueClassConstraint())));
        }
    }
}

