/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.examplejavafx;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.examplejavafx.AbstractColumn;

public class GenericsTable
extends TableView<Generic> {
    public GenericsTable(Generic type, Generic ... attributes) {
        this.setEditable(true);
        AbstractColumn.GenericColumn<String> firstColumn = new AbstractColumn.GenericColumn<String>(type, Objects.toString(type.getValue()), g -> Objects.toString(g.getValue()), (g, v) -> {
            Generic cfr_ignored_0 = (Generic)g.updateValue((Serializable)((Object)v));
        });
        this.getColumns().add(firstColumn);
        for (Generic attribute : attributes) {
            AbstractColumn column = attribute.getComponents().size() < 2 ? new AbstractColumn.GenericColumn<Serializable>(attribute, Objects.toString(attribute.getValue()), g -> g.getValue((DefaultGeneric)attribute, (DefaultGeneric[])new Generic[0]), (g, v) -> {
                Generic cfr_ignored_0 = (Generic)g.setHolder((DefaultGeneric)attribute, v, (DefaultGeneric[])new Generic[0]);
            }) : new AbstractColumn.TargetComponentColumn((Generic)attribute.getTargetComponent(), Objects.toString(((Generic)attribute.getTargetComponent()).getValue()), g -> (Generic)((Generic)g.getHolder((DefaultGeneric)attribute, (DefaultGeneric[])new Generic[0])).getTargetComponent(), (g, v) -> {
                Generic cfr_ignored_0 = (Generic)g.setLink((DefaultGeneric)attribute, null, (DefaultGeneric)v, (DefaultGeneric[])new Generic[0]);
            });
            this.getColumns().add(column);
        }
        this.getColumns().add((Object)new DeleteColumn());
        ObservableList data = FXCollections.observableArrayList((Collection)type.getInstances().stream().collect(Collectors.toList()));
        this.setItems(data);
    }

    public static class DeleteButtonCell
    extends TableCell<Generic, Generic> {
        private final Button cellButton = new Button();

        public DeleteButtonCell() {
            this.cellButton.setMaxWidth(200.0);
            this.cellButton.setAlignment(Pos.BASELINE_CENTER);
        }

        protected void updateItem(final Generic t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (empty || t == null) {
                this.cellButton.setText(null);
                this.setGraphic(null);
            } else {
                this.cellButton.setText("Delete");
                this.setGraphic((Node)this.cellButton);
                this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirmation Dialog");
                        alert.setHeaderText("Confirmation is required");
                        alert.setContentText("Are you sure you want to delete : " + t.info() + " ?");
                        Optional result = alert.showAndWait();
                        if (result.get() == ButtonType.OK) {
                            t.remove();
                            this.getTableView().getItems().remove((Object)t);
                            System.out.println("Remove : " + t.info());
                        }
                    }
                });
            }
        }
    }

    public static class DeleteColumn
    extends TableColumn<Generic, Generic> {
        public DeleteColumn() {
            super("Delete");
            this.setMinWidth(200.0);
            this.setCellValueFactory(cellData -> new ReadOnlyObjectWrapper(cellData.getValue()));
            this.setEditable(true);
            this.setCellFactory(column -> new DeleteButtonCell());
        }
    }
}

