/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genericsystem.api.core.IGeneric;
import org.genericsystem.defaults.DefaultCache;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.defaults.DefaultRoot;

public interface DefaultWritable<T extends DefaultGeneric<T>>
extends IGeneric<T> {
    default public T updateValue(Serializable newValue) {
        return (T)((DefaultGeneric)this.update(this.getSupers(), newValue, this.coerceToTArray(this.getComponents().toArray())));
    }

    default public T updateSupers(T ... supers) {
        return (T)((DefaultGeneric)this.update(Arrays.asList(supers), this.getValue(), this.coerceToTArray(this.getComponents().toArray())));
    }

    default public T updateComponent(T targetComponent, int pos) {
        ArrayList<T> newComponents = new ArrayList<T>(this.getComponents());
        newComponents.set(pos, targetComponent);
        return (T)this.getCurrentCache().update((DefaultGeneric)this, this.getSupers(), this.getValue(), newComponents);
    }

    default public T updateComponents(T ... newComponents) {
        return (T)((DefaultGeneric)this.update(this.getSupers(), this.getValue(), (IGeneric[])newComponents));
    }

    default public T update(Serializable newValue, T ... newComponents) {
        return (T)((DefaultGeneric)this.update(this.getSupers(), newValue, (IGeneric[])newComponents));
    }

    default public T update(T override, Serializable newValue, T ... newComponents) {
        return (T)((DefaultGeneric)this.update(Collections.singletonList(override), newValue, (IGeneric[])newComponents));
    }

    default public T setInstance(Serializable value, T ... components) {
        return (T)((DefaultGeneric)this.setInstance(Collections.emptyList(), value, (IGeneric[])components));
    }

    default public T setInstance(T override, Serializable value, T ... components) {
        return (T)((DefaultGeneric)this.setInstance(Collections.singletonList(override), value, (IGeneric[])components));
    }

    default public T addInstance(Serializable value, T ... components) {
        return (T)((DefaultGeneric)this.addInstance(Collections.emptyList(), value, (IGeneric[])components));
    }

    default public T addInstance(T override, Serializable value, T ... components) {
        return (T)((DefaultGeneric)this.addInstance(Collections.singletonList(override), value, (IGeneric[])components));
    }

    default public T addAttribute(Serializable value, T ... targets) {
        return (T)this.addAttribute(Collections.emptyList(), value, (DefaultGeneric[])targets);
    }

    default public T setAttribute(Serializable value, T ... targets) {
        return (T)this.setAttribute(Collections.emptyList(), value, (DefaultGeneric[])targets);
    }

    default public T addRelation(Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.addRelation(Collections.emptyList(), value, (DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets);
    }

    default public T setRelation(Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.setRelation(Collections.emptyList(), value, (DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets);
    }

    default public T addHolder(T attribute, Serializable value, T ... targets) {
        return (T)attribute.addInstance(value, this.addThisToTargets((DefaultGeneric[])targets));
    }

    default public T setHolder(T attribute, Serializable value, T ... targets) {
        return (T)attribute.setInstance(value, this.addThisToTargets((DefaultGeneric[])targets));
    }

    default public T addLink(T relation, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.addInstance(value, this.addThisToTargets((DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets));
    }

    default public T setLink(T relation, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.setInstance(value, this.addThisToTargets((DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets));
    }

    default public T addAttribute(T override, Serializable value, T ... targets) {
        return (T)this.addAttribute(Collections.singletonList(override), value, (DefaultGeneric[])targets);
    }

    default public T setAttribute(T override, Serializable value, T ... targets) {
        return (T)this.setAttribute(Collections.singletonList(override), value, (DefaultGeneric[])targets);
    }

    default public T addRelation(T override, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.addRelation(Collections.singletonList(override), value, (DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets);
    }

    default public T setRelation(T override, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.setRelation(Collections.singletonList(override), value, (DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets);
    }

    default public T addHolder(T attribute, T override, Serializable value, T ... targets) {
        return (T)attribute.addInstance(override, value, this.addThisToTargets((DefaultGeneric[])targets));
    }

    default public T setHolder(T attribute, T override, Serializable value, T ... targets) {
        return (T)attribute.setInstance(override, value, this.addThisToTargets((DefaultGeneric[])targets));
    }

    default public T addLink(T relation, T override, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.addInstance(override, value, this.addThisToTargets((DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets));
    }

    default public T setLink(T relation, T override, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.setInstance(override, value, this.addThisToTargets((DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets));
    }

    default public T addAttribute(List<T> overrides, Serializable value, T ... targets) {
        return (T)this.getRoot().addInstance(overrides, value, this.addThisToTargets((DefaultGeneric[])targets));
    }

    default public T setAttribute(List<T> overrides, Serializable value, T ... targets) {
        return (T)this.getRoot().setInstance(overrides, value, this.addThisToTargets((DefaultGeneric[])targets));
    }

    default public T addRelation(List<T> overrides, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.getRoot().addInstance(overrides, value, this.addThisToTargets((DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets));
    }

    default public T setRelation(List<T> overrides, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.getRoot().setInstance(overrides, value, this.addThisToTargets((DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets));
    }

    default public T addHolder(T attribute, List<T> overrides, Serializable value, T ... targets) {
        return (T)attribute.addInstance(overrides, value, this.addThisToTargets((DefaultGeneric[])targets));
    }

    default public T setHolder(T attribute, List<T> overrides, Serializable value, T ... targets) {
        return (T)attribute.setInstance(overrides, value, this.addThisToTargets((DefaultGeneric[])targets));
    }

    default public T addLink(T relation, List<T> overrides, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.addInstance(overrides, value, this.addThisToTargets((DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets));
    }

    default public T setLink(T relation, List<T> overrides, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.setInstance(overrides, value, this.addThisToTargets((DefaultGeneric)firstTarget, (DefaultGeneric[])otherTargets));
    }

    default public DefaultCache<T> getCurrentCache() {
        return this.getRoot().getCurrentCache();
    }

    public DefaultRoot<T> getRoot();

    default public T[] addThisToTargets(T ... targets) {
        DefaultGeneric[] composites = this.getRoot().newTArray(targets.length + 1);
        composites[0] = (DefaultGeneric)this;
        System.arraycopy(targets, 0, composites, 1, targets.length);
        return composites;
    }

    default public T[] addThisToTargets(T firstTarget, T ... otherTargets) {
        return this.addThisToTargets(firstTarget.addThisToTargets(otherTargets));
    }

    default public void forceRemove() {
        this.getCurrentCache().forceRemove((DefaultGeneric)this);
    }

    default public void conserveRemove() {
        this.getCurrentCache().conserveRemove((DefaultGeneric)this);
    }

    default public void remove() {
        this.getCurrentCache().remove((DefaultGeneric)this);
    }
}

