/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.genericsystem.api.core.ApiStatics;
import org.genericsystem.api.core.FiltersBuilder;
import org.genericsystem.api.core.IContext;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.exceptions.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.api.core.exceptions.UnreachableOverridesException;
import org.genericsystem.api.tools.Memoizer;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.defaults.DefaultRoot;
import org.genericsystem.defaults.tools.SupersComputer;

public interface DefaultContext<T extends DefaultGeneric<T>>
extends IContext<T> {
    public DefaultRoot<T> getRoot();

    default public boolean isAlive(T vertex) {
        if (!1.$assertionsDisabled && vertex == null) {
            throw new AssertionError();
        }
        class AliveFinder {
            AliveFinder() {
            }

            T find(T vertex) {
                if (vertex.isRoot()) {
                    return vertex;
                }
                if (vertex.isMeta()) {
                    Object aliveSuper = new AliveFinder().find((DefaultGeneric)vertex.getSupers().get(0));
                    return aliveSuper != null ? (DefaultGeneric)DefaultContext.this.getInheritings(aliveSuper).get(vertex) : null;
                }
                Object aliveMeta = new AliveFinder().find((DefaultGeneric)vertex.getMeta());
                return aliveMeta != null ? (DefaultGeneric)DefaultContext.this.getInstances(aliveMeta).get(vertex) : null;
            }
        }
        return vertex.equals(new AliveFinder().find(vertex));
    }

    default public Snapshot<T> getInstances(T vertex) {
        return this.getDependencies(vertex).filter(new IndexFilter(FiltersBuilder.INSTANCES, new Object[]{vertex}));
    }

    default public Snapshot<T> getInheritings(T vertex) {
        return this.getDependencies(vertex).filter(new IndexFilter(FiltersBuilder.INHERITINGS, new Object[]{vertex}));
    }

    default public Snapshot<T> getComposites(T vertex) {
        return this.getDependencies(vertex).filter(new IndexFilter(FiltersBuilder.COMPOSITES, new Object[]{vertex}));
    }

    default public void discardWithException(Throwable exception) throws RollbackException {
        throw new RollbackException(exception);
    }

    default public NavigableSet<T> computeDependencies(T node) {
        class OrderedDependencies
        extends TreeSet<T> {
            private static final long serialVersionUID = -441180182522681264L;

            OrderedDependencies() {
            }

            OrderedDependencies visit(T node) {
                if (this.add(node)) {
                    DefaultContext.this.getDependencies(node).stream().forEach(this::visit);
                }
                return this;
            }
        }
        return new OrderedDependencies().visit(node);
    }

    default public NavigableSet<T> computePotentialDependencies(T meta, List<T> supers, Serializable value, List<T> components) {
        Function[] memoizedIsDependencyA;
        memoizedIsDependencyA = new Function[]{Memoizer.memoize(node -> node.inheritsFrom(meta, supers, value, components) || node.getComponents().stream().anyMatch(component -> (Boolean)memoizedIsDependencyA[0].apply(component)) || !node.isMeta() && (Boolean)memoizedIsDependencyA[0].apply(node.getMeta()) != false || !components.equals(node.getComponents()) && node.componentsDepends(node.getComponents(), components) && supers.stream().anyMatch(override -> override.inheritsFrom((DefaultGeneric)node.getMeta())))};
        Function memoizedIsDependency = memoizedIsDependencyA[0];
        if (components.isEmpty()) {
            return meta.isMeta() ? new TreeSet(this.computeDependencies(meta).stream().filter(node -> (Boolean)memoizedIsDependency.apply(node)).collect(Collectors.toSet())) : new TreeSet();
        }
        return new TreeSet(this.computeDependencies((DefaultGeneric)components.get(0)).stream().filter(node -> (Boolean)memoizedIsDependency.apply(node)).collect(Collectors.toSet()));
    }

    default public NavigableSet<T> computeRemoveDependencies(T node) {
        class OrderedRemoveDependencies
        extends TreeSet<T> {
            private static final long serialVersionUID = -5970021419012502402L;

            OrderedRemoveDependencies() {
            }

            OrderedRemoveDependencies visit(T node) {
                if (!this.contains(node)) {
                    if (!DefaultContext.this.getInheritings(node).isEmpty()) {
                        DefaultContext.this.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Ancestor : " + node + " has a inheriting dependencies : " + DefaultContext.this.getInheritings(node).info()));
                    }
                    DefaultContext.this.getInheritings(node).forEach(this::visit);
                    if (!DefaultContext.this.getInstances(node).isEmpty()) {
                        DefaultContext.this.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException("Ancestor : " + node + " has a instance dependencies : " + DefaultContext.this.getInstances(node).info()));
                    }
                    DefaultContext.this.getInstances(node).forEach(this::visit);
                    for (DefaultGeneric composite : DefaultContext.this.getComposites(node)) {
                        for (int componentPos = 0; componentPos < composite.getComponents().size(); ++componentPos) {
                            if (!((DefaultGeneric)composite.getComponents().get(componentPos)).equals(node) || this.contains(composite) || !((DefaultGeneric)composite.getMeta()).isReferentialIntegrityEnabled(componentPos)) continue;
                            DefaultContext.this.discardWithException((Throwable)new ReferentialIntegrityConstraintViolationException(composite + " is Referential Integrity for ancestor " + node + " by composite position : " + componentPos));
                        }
                        this.visit(composite);
                    }
                    this.add(node);
                    for (int axe = 0; axe < node.getComponents().size(); ++axe) {
                        if (!node.isCascadeRemoveEnabled(axe)) continue;
                        this.visit((DefaultGeneric)node.getComponents().get(axe));
                    }
                }
                return this;
            }
        }
        return new OrderedRemoveDependencies().visit(node);
    }

    default public List<T> computeAndCheckOverridesAreReached(T adjustedMeta, List<T> overrides, Serializable value, List<T> components) {
        ArrayList<T> supers = new ArrayList<T>(new SupersComputer<T>(adjustedMeta, overrides, value, components));
        if (!ApiStatics.areOverridesReached(supers, overrides)) {
            this.discardWithException((Throwable)new UnreachableOverridesException("Unable to reach overrides : " + overrides + " with computed supers : " + supers));
        }
        return supers;
    }

    public Snapshot<T> getDependencies(T var1);

    public Snapshot<T> getSubInstances(T var1);

    public Snapshot<T> getSubInheritings(T var1);

    default public T getMeta(int dim) {
        DefaultGeneric adjustedMeta = this.getRoot().adjustMeta(this.rootComponents(dim));
        return (T)(adjustedMeta != null && adjustedMeta.getComponents().size() == dim ? adjustedMeta : null);
    }

    default public T[] rootComponents(int dim) {
        Object[] components = this.getRoot().newTArray(dim);
        Arrays.fill(components, this.getRoot());
        return components;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

