/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import io.reactivex.Observable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.genericsystem.api.core.FiltersBuilder;
import org.genericsystem.api.core.IGeneric;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.defaults.DefaultGeneric;

public interface DefaultCompositesInheritance<T extends DefaultGeneric<T>>
extends IGeneric<T> {
    default public T getAttribute(Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getAttributes(value, (DefaultGeneric[])targets).stream());
    }

    default public Observable<Optional<T>> getObservableAttribute(Serializable value, T ... targets) {
        return this.getAttributes(value, (DefaultGeneric[])targets).firstOnChanged();
    }

    default public T getAttribute(T ... targets) {
        return this.getNonAmbiguousResult(this.getAttributes((T)targets).stream());
    }

    default public Observable<Optional<T>> getObservableAttribute(T ... targets) {
        return this.getAttributes((T)targets).firstOnChanged();
    }

    default public Snapshot<T> getAttributes(Serializable value, T ... targets) {
        return this.getAttributes((T)targets).filter(new IndexFilter(FiltersBuilder.HAS_VALUE, new Object[]{value}));
    }

    default public Snapshot<T> getAttributes() {
        return this.getAttributes((T)((DefaultGeneric)this.getRoot().getMetaAttribute()));
    }

    default public Snapshot<T> getAttributes(T ... targets) {
        return this.getAttributes((T)((DefaultGeneric)this.getRoot().getMetaAttribute())).filter(new IndexFilter(FiltersBuilder.COMPOSITE_HAS_COMPONENTS, (Object[])this.addThisToTargets((IGeneric[])targets)));
    }

    default public Snapshot<T> getAttributes(int pos) {
        return this.getAttributes().filter(new IndexFilter(FiltersBuilder.HAS_COMPONENT_AT_POS, new Object[]{this, pos}));
    }

    default public Snapshot<T> getAttributes(T attribute) {
        return this.getCurrentCache().getAttributes((IGeneric)((DefaultGeneric)this), attribute);
    }

    default public T getHolder(T attribute, Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getHolders((DefaultGeneric)attribute, value, (DefaultGeneric[])targets).stream());
    }

    default public Observable<Optional<T>> getObservableHolder(T attribute, Serializable value, T ... targets) {
        return this.getHolders((DefaultGeneric)attribute, value, (DefaultGeneric[])targets).firstOnChanged();
    }

    default public T getHolder(T attribute, T ... targets) {
        return this.getNonAmbiguousResult(this.getHolders((DefaultGeneric)attribute, (DefaultGeneric[])targets).stream());
    }

    default public Observable<Optional<T>> getObservableHolder(T attribute, T ... targets) {
        return this.getHolders((DefaultGeneric)attribute, (DefaultGeneric[])targets).firstOnChanged();
    }

    default public Snapshot<T> getHolders(T attribute, Serializable value, T ... targets) {
        return this.getHolders((DefaultGeneric)attribute, (DefaultGeneric[])targets).filter(new IndexFilter(FiltersBuilder.HAS_VALUE, new Object[]{value}));
    }

    default public Snapshot<T> getHolders(T attribute, T ... targets) {
        return this.getHolders(attribute).filter(new IndexFilter(FiltersBuilder.COMPOSITE_HAS_COMPONENTS, (Object[])this.addThisToTargets((IGeneric[])targets)));
    }

    default public Snapshot<T> getHolders(T attribute, int pos) {
        return this.getHolders(attribute).filter(new IndexFilter(FiltersBuilder.HAS_COMPONENT_AT_POS, new Object[]{this, pos}));
    }

    default public Snapshot<T> getHolders(T attribute) {
        return this.getCurrentCache().getHolders((IGeneric)((DefaultGeneric)this), attribute);
    }

    default public T getRelation(Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getRelations(value, (DefaultGeneric[])targets).stream());
    }

    default public Observable<Optional<T>> getObservableRelation(Serializable value, T ... targets) {
        return this.getRelations(value, (DefaultGeneric[])targets).firstOnChanged();
    }

    default public T getRelation(T ... targets) {
        return this.getNonAmbiguousResult(this.getRelations((T)targets).stream());
    }

    default public Observable<Optional<T>> getObservableRelation(T ... targets) {
        return this.getRelations((T)targets).firstOnChanged();
    }

    default public Snapshot<T> getRelations(Serializable value, T ... targets) {
        return this.getRelations((T)targets).filter(new IndexFilter(FiltersBuilder.HAS_VALUE, new Object[]{value}));
    }

    default public Snapshot<T> getRelations(T ... targets) {
        return this.getRelations((T)((DefaultGeneric)this.getRoot().getMetaRelation())).filter(new IndexFilter(FiltersBuilder.COMPOSITE_HAS_COMPONENTS, (Object[])this.addThisToTargets((IGeneric[])targets)));
    }

    default public Snapshot<T> getRelations(int pos) {
        return this.getRelations((T)new DefaultGeneric[0]).filter(new IndexFilter(FiltersBuilder.HAS_COMPONENT_AT_POS, new Object[]{this, pos}));
    }

    default public Snapshot<T> getRelations(T relation) {
        return ((DefaultGeneric)this).getAttributes((DefaultGeneric)relation);
    }

    default public T getLink(T relation, Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getLinks((DefaultGeneric)relation, value, (DefaultGeneric[])targets).stream());
    }

    default public Observable<Optional<T>> getObservableLink(T relation, Serializable value, T ... targets) {
        return this.getLinks((DefaultGeneric)relation, value, (DefaultGeneric[])targets).firstOnChanged();
    }

    default public T getLink(T relation, T ... targets) {
        return this.getNonAmbiguousResult(this.getLinks((DefaultGeneric)relation, (DefaultGeneric[])targets).stream());
    }

    default public Observable<Optional<T>> getObservableLink(T relation, T ... targets) {
        return this.getLinks((DefaultGeneric)relation, (DefaultGeneric[])targets).firstOnChanged();
    }

    default public Snapshot<T> getLinks(T relation, Serializable value, T ... targets) {
        return this.getLinks((DefaultGeneric)relation, (DefaultGeneric[])targets).filter(new IndexFilter(FiltersBuilder.HAS_VALUE, new Object[]{value}));
    }

    default public Snapshot<T> getLinks(T relation, T ... targets) {
        return this.getLinks(relation).filter(new IndexFilter(FiltersBuilder.COMPOSITE_HAS_COMPONENTS, (Object[])this.addThisToTargets((IGeneric[])targets)));
    }

    default public Snapshot<T> getLinks(T relation, int pos) {
        return this.getLinks(relation).filter(new IndexFilter(FiltersBuilder.HAS_COMPONENT_AT_POS, new Object[]{this, pos}));
    }

    default public Snapshot<T> getLinks(T relation) {
        return ((DefaultGeneric)this).getHolders((DefaultGeneric)relation);
    }

    default public Serializable getValue(T attribute, Serializable value, T ... targets) {
        DefaultGeneric holder = this.getHolder((DefaultGeneric)attribute, value, (DefaultGeneric[])targets);
        return holder != null ? holder.getValue() : null;
    }

    default public Observable<Optional<Serializable>> getObservableValue(T attribute, Serializable value, T ... targets) {
        return this.getObservableHolder((DefaultGeneric)attribute, value, (DefaultGeneric[])targets).map(optHolder -> optHolder.isPresent() ? Optional.of(((DefaultGeneric)optHolder.get()).getValue()) : Optional.empty());
    }

    default public Serializable getValue(T attribute, T ... targets) {
        DefaultGeneric holder = this.getHolder((DefaultGeneric)attribute, (DefaultGeneric[])targets);
        return holder != null ? holder.getValue() : null;
    }

    default public Observable<Optional<Serializable>> getObservableValue(T attribute, T ... targets) {
        return this.getObservableHolder((DefaultGeneric)attribute, (DefaultGeneric[])targets).map(optHolder -> optHolder.isPresent() ? Optional.of(((DefaultGeneric)optHolder.get()).getValue()) : Optional.empty());
    }

    default public Snapshot<Serializable> getValues(final T attribute, final Serializable value, final T ... targets) {
        return new Snapshot<Serializable>(){
            private Observable<Serializable> adds;
            private Observable<Serializable> removals;
            {
                this.adds = DefaultCompositesInheritance.this.getLinks(attribute, value, targets).getAdds().map(h -> h.getValue()).share();
                this.removals = DefaultCompositesInheritance.this.getLinks(attribute, value, targets).getRemovals().map(h -> h.getValue()).share();
            }

            public Stream<Serializable> unfilteredStream() {
                return DefaultCompositesInheritance.this.getLinks(attribute, value, targets).stream().map(x -> x.getValue());
            }

            public Observable<Serializable> getAdds() {
                return this.adds;
            }

            public Observable<Serializable> getRemovals() {
                return this.removals;
            }
        };
    }

    default public Snapshot<Serializable> getValues(final T attribute, final T ... targets) {
        return new Snapshot<Serializable>(){
            private Observable<Serializable> adds;
            private Observable<Serializable> removals;
            {
                this.adds = DefaultCompositesInheritance.this.getLinks(attribute, targets).getAdds().map(h -> h.getValue()).share();
                this.removals = DefaultCompositesInheritance.this.getLinks(attribute, targets).getRemovals().map(h -> h.getValue()).share();
            }

            public Stream<Serializable> unfilteredStream() {
                return DefaultCompositesInheritance.this.getLinks(attribute, targets).stream().map(x -> x.getValue());
            }

            public Observable<Serializable> getAdds() {
                return this.adds;
            }

            public Observable<Serializable> getRemovals() {
                return this.removals;
            }
        };
    }

    default public Snapshot<Serializable> getValues(final T attribute, final int pos) {
        return new Snapshot<Serializable>(){
            private Observable<Serializable> adds;
            private Observable<Serializable> removals;
            {
                this.adds = DefaultCompositesInheritance.this.getHolders(attribute, pos).getAdds().map(h -> h.getValue()).share();
                this.removals = DefaultCompositesInheritance.this.getHolders(attribute, pos).getRemovals().map(h -> h.getValue()).share();
            }

            public Stream<Serializable> unfilteredStream() {
                return DefaultCompositesInheritance.this.getHolders(attribute, pos).stream().map(x -> x.getValue());
            }

            public Observable<Serializable> getAdds() {
                return this.adds;
            }

            public Observable<Serializable> getRemovals() {
                return this.removals;
            }
        };
    }

    public static <T extends DefaultGeneric<T>> Predicate<T> componentsFilter(T ... componentsReached) {
        return attribute -> {
            ArrayList attributeComps = new ArrayList(attribute.getComponents());
            for (DefaultGeneric componentReach : componentsReached) {
                DefaultGeneric matchedComponent = attributeComps.stream().filter(attributeComp -> componentsReached[0].isSpecializationOf(attributeComp) ? true : componentReach.equals(attributeComp)).findFirst().orElse(null);
                if (matchedComponent == null) {
                    return false;
                }
                attributeComps.remove(matchedComponent);
            }
            return true;
        };
    }

    public T getNonAmbiguousResult(Stream<T> var1);

    default public T getLinkTargetComponent(T relation, T ... targets) {
        DefaultGeneric link = this.getLink((DefaultGeneric)relation, (DefaultGeneric[])targets);
        return (T)(link != null ? link.getTargetComponent() : null);
    }

    default public Observable<Optional<T>> getObservableLinkTargetComponent(T relation, T ... targets) {
        return this.getObservableLink((DefaultGeneric)relation, (DefaultGeneric[])targets).map(optLink -> optLink.isPresent() ? Optional.of(((DefaultGeneric)optLink.get()).getTargetComponent()) : Optional.empty());
    }

    default public T getLinkTargetComponent(T relation, Serializable value, T ... targets) {
        DefaultGeneric link = this.getLink((DefaultGeneric)relation, value, (DefaultGeneric[])targets);
        return (T)(link != null ? link.getTargetComponent() : null);
    }

    default public Observable<Optional<T>> getObservableLinkTargetComponent(T relation, Serializable value, T ... targets) {
        return this.getObservableLink((DefaultGeneric)relation, value, (DefaultGeneric[])targets).map(optLink -> optLink.isPresent() ? Optional.of(((DefaultGeneric)optLink.get()).getTargetComponent()) : Optional.empty());
    }
}

