/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults.tools;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.api.core.FiltersBuilder;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.defaults.DefaultGeneric;

public class InheritanceComputer<T extends DefaultGeneric<T>> {
    private final Map<T, Observable<T>> addsCache = new HashMap<T, Observable<T>>();
    private final Map<T, Observable<T>> removesCache = new HashMap<T, Observable<T>>();
    private final Set<T> overridden = new HashSet<T>();
    private final T base;
    private final T origin;
    private final int level;
    private final Predicate<T> inheritingsFilter;

    public InheritanceComputer(T base, T origin, int level) {
        this.base = base;
        this.origin = origin;
        this.level = level;
        this.inheritingsFilter = holder -> !this.overridden.contains(holder) && !holder.equals(origin) && holder.getLevel() == level;
    }

    public Stream<T> inheritanceStream() {
        return this.getInheritingsStream(this.base).filter(holder -> this.inheritingsFilter.test((DefaultGeneric)holder));
    }

    public Observable<T> getAdds() {
        return this.getAdds(this.base).filter(holder -> this.inheritingsFilter.test((DefaultGeneric)holder)).share();
    }

    public Observable<T> getRemovals() {
        return this.getRemovals(this.base).filter(holder -> this.inheritingsFilter.test((DefaultGeneric)holder)).share();
    }

    private Stream<T> getInheritingsStream(T superVertex) {
        return this.buildInheritings(superVertex).inheritanceStream();
    }

    private Observable<T> getAdds(T superVertex) {
        Observable result = this.addsCache.get(superVertex);
        if (result == null) {
            result = this.buildInheritings(superVertex).inheritanceStreamAdds();
            this.addsCache.put(superVertex, result);
        }
        return result;
    }

    private Observable<T> getRemovals(T superVertex) {
        Observable result = this.removesCache.get(superVertex);
        if (result == null) {
            result = this.buildInheritings(superVertex).inheritanceStreamRemoves();
            this.removesCache.put(superVertex, result);
        }
        return result;
    }

    protected Inheritings buildInheritings(T superVertex) {
        return new Inheritings(this, superVertex);
    }

    protected static class Inheritings {
        protected final T localBase;
        final /* synthetic */ InheritanceComputer this$0;

        protected Inheritings(T localBase) {
            this.this$0 = this$0;
            this.localBase = localBase;
        }

        private boolean hasIntermediateSuperOrIsMeta() {
            return this.localBase.isMeta() || this.localBase.getSupers().stream().filter(next -> ((DefaultGeneric)this.localBase.getMeta()).equals(next.getMeta())).count() != 0L;
        }

        private Stream<T> metaAndSupersStream() {
            return Stream.concat(this.hasIntermediateSuperOrIsMeta() ? Stream.empty() : Stream.of(this.localBase.getMeta()), this.localBase.getSupers().stream()).distinct();
        }

        private Stream<T> inheritanceStream() {
            return this.fromAboveStream().flatMap(holder -> this.getStream(holder)).distinct();
        }

        private Observable<T> inheritanceStreamAdds() {
            return Observable.merge((ObservableSource)this.fromAboveAdds().flatMap(holder -> this.getObservable(this.getStream(holder))), (ObservableSource)Observable.merge(this.fromAboveAdds(), this.getObservable(this.fromAboveStream())).flatMap(holder -> this.getStreamAdds(holder))).share();
        }

        private Observable<T> inheritanceStreamRemoves() {
            return Observable.merge((ObservableSource)Observable.merge(this.fromAboveAdds(), this.getObservable(this.fromAboveStream())).flatMap(holder -> this.getStreamRemoves(holder)), (ObservableSource)this.fromAboveRemoves().flatMap(holder -> this.getObservable(this.getStream(holder)))).share();
        }

        private Stream<T> fromAboveStream() {
            return this.localBase.isRoot() ? Stream.of(this.this$0.origin) : this.metaAndSupersStream().flatMap(x$0 -> this.this$0.getInheritingsStream(x$0)).distinct();
        }

        private Observable<T> fromAboveAdds() {
            return this.localBase.isRoot() ? Observable.never() : this.getObservable(this.metaAndSupersStream()).flatMap(x$0 -> this.this$0.getAdds(x$0)).share();
        }

        private Observable<T> fromAboveRemoves() {
            return this.localBase.isRoot() ? Observable.never() : this.getObservable(this.metaAndSupersStream()).flatMap(x$0 -> this.this$0.getRemovals(x$0)).share();
        }

        private Stream<T> getIndexStream(T holder) {
            return Stream.concat(holder.getLevel() < this.this$0.level ? this.compositesByMeta(holder).stream() : Stream.empty(), this.compositesBySuper(holder).stream());
        }

        private Observable<T> getIndexStreamAdds(T holder) {
            return Observable.merge((ObservableSource)(holder.getLevel() < this.this$0.level ? this.compositesByMeta(holder).getAdds() : Observable.never()), (ObservableSource)this.compositesBySuper(holder).getAdds()).share();
        }

        private Observable<T> getIndexStreamRemoves(T holder) {
            return Observable.merge((ObservableSource)(holder.getLevel() < this.this$0.level ? this.compositesByMeta(holder).getRemovals() : Observable.never()), (ObservableSource)this.compositesBySuper(holder).getRemovals()).share();
        }

        private Stream<T> getStream(T holder) {
            if (this.compositesBySuper(holder).stream().count() != 0L) {
                this.this$0.overridden.add(holder);
            }
            return Stream.concat(Stream.of(holder), this.getIndexStream(holder).flatMap(x -> this.getStream(x)).distinct());
        }

        private Observable<T> getStreamAdds(T holder) {
            Observable indexAdds = this.getIndexStreamAdds(holder);
            return Observable.merge((ObservableSource)Observable.merge(this.getObservable(this.getIndexStream(holder)), indexAdds).flatMap(x -> this.getStreamAdds(x)), (ObservableSource)indexAdds.flatMap(x -> this.getObservable(this.getStream(x)))).share();
        }

        private Observable<T> getStreamRemoves(T holder) {
            return Observable.merge((ObservableSource)this.getIndexStreamRemoves(holder).flatMap(x -> this.getObservable(this.getStream(x))), (ObservableSource)Observable.merge(this.getObservable(this.getIndexStream(holder)), this.getIndexStreamAdds(holder)).flatMap(x -> this.getStreamRemoves(x))).share();
        }

        private Snapshot<T> compositesByMeta(T holder) {
            return this.localBase.getDependencies().filter(Arrays.asList(new IndexFilter(FiltersBuilder.COMPOSITES, new Object[]{this.localBase}), new IndexFilter(FiltersBuilder.HAS_META, new Object[]{holder})));
        }

        private Snapshot<T> compositesBySuper(T holder) {
            return this.localBase.getDependencies().filter(Arrays.asList(new IndexFilter(FiltersBuilder.COMPOSITES, new Object[]{this.localBase}), new IndexFilter(FiltersBuilder.HAS_SUPER, new Object[]{holder})));
        }

        private Observable<T> getObservable(Stream<T> stream) {
            return Observable.fromIterable((Iterable)stream.collect(Collectors.toList())).share();
        }
    }
}

