/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults.tools;

import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import javafx.beans.WeakListener;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidirectionalBinding<S, T>
implements ChangeListener<Object>,
WeakListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final WeakReference<Property<S>> stringPropertyRef;
    private final WeakReference<Property<T>> otherPropertyRef;
    private boolean updating;
    private final Function<S, T> fromS;
    private final Function<T, S> toS;
    private final int cachedHashCode;

    public static <S, T> BidirectionalBinding<S, T> bind(Property<S> property, Property<T> otherProperty, Function<S, T> to, Function<T, S> from) {
        BidirectionalBinding<S, T> binding = new BidirectionalBinding<S, T>(property, otherProperty, to, from);
        property.setValue(from.apply(otherProperty.getValue()));
        property.addListener(binding);
        otherProperty.addListener(binding);
        return binding;
    }

    public BidirectionalBinding(Property<S> stringProperty, Property<T> otherProperty, Function<S, T> fromS, Function<T, S> toS) {
        this.stringPropertyRef = new WeakReference<Property<S>>(stringProperty);
        this.otherPropertyRef = new WeakReference<Property<Property<T>>>(otherProperty);
        this.cachedHashCode = stringProperty.hashCode() * otherProperty.hashCode();
        this.fromS = fromS;
        this.toS = toS;
    }

    protected S toString(T value) {
        return this.toS.apply(value);
    }

    protected T fromString(S value) {
        return this.fromS.apply(value);
    }

    protected Object getProperty1() {
        return this.stringPropertyRef.get();
    }

    protected Object getProperty2() {
        return this.otherPropertyRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
        if (!this.updating) {
            Property property1 = (Property)this.stringPropertyRef.get();
            Property property2 = (Property)this.otherPropertyRef.get();
            if (property1 == null || property2 == null) {
                if (property1 != null) {
                    property1.removeListener((ChangeListener)this);
                }
                if (property2 != null) {
                    property2.removeListener((ChangeListener)this);
                }
            } else {
                try {
                    this.updating = true;
                    if (property1 == observable) {
                        try {
                            property2.setValue(this.fromString(property1.getValue()));
                        }
                        catch (Exception e) {
                            logger.warn("Exception while parsing String in bidirectional binding.", (Throwable)e);
                            property2.setValue(null);
                        }
                    } else {
                        try {
                            property1.setValue(this.toString(property2.getValue()));
                        }
                        catch (Exception e) {
                            logger.warn("Exception while converting Object to String in bidirectional binding.", (Throwable)e);
                            property1.setValue(null);
                        }
                    }
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean wasGarbageCollected() {
        return this.getProperty1() == null || this.getProperty2() == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object propertyA1 = this.getProperty1();
        Object propertyA2 = this.getProperty2();
        if (propertyA1 == null || propertyA2 == null) {
            return false;
        }
        if (obj instanceof BidirectionalBinding) {
            BidirectionalBinding otherBinding = (BidirectionalBinding)obj;
            Object propertyB1 = otherBinding.getProperty1();
            Object propertyB2 = otherBinding.getProperty2();
            if (propertyB1 == null || propertyB2 == null) {
                return false;
            }
            if (propertyA1 == propertyB1 && propertyA2 == propertyB2) {
                return true;
            }
            if (propertyA1 == propertyB2 && propertyA2 == propertyB1) {
                return true;
            }
        }
        return false;
    }
}

