/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults;

import org.genericsystem.api.core.IGeneric;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.defaults.DefaultRoot;

public interface DefaultAncestors<T extends DefaultGeneric<T>>
extends IGeneric<T> {
    default public boolean isRoot() {
        return this.equals(this.getRoot());
    }

    default public int getLevel() {
        return this == this.getMeta() ? 0 : ((DefaultGeneric)this.getMeta()).getLevel() + 1;
    }

    public DefaultRoot<T> getRoot();

    default public boolean isMeta() {
        return this.getLevel() == 0;
    }

    default public boolean isStructural() {
        return this.getLevel() == 1;
    }

    default public boolean isConcrete() {
        return this.getLevel() == 2;
    }

    default public boolean isDirectAncestorOf(T vertex) {
        return !this.equals(vertex) && (this.equals(vertex.getMeta()) || vertex.getSupers().contains(this) || vertex.getComponents().contains(this));
    }

    default public boolean inheritsFrom(T superVertex) {
        if (this.equals(superVertex)) {
            return true;
        }
        if (this.getLevel() != superVertex.getLevel()) {
            return false;
        }
        for (DefaultGeneric superT : this.getSupers()) {
            if (!superT.inheritsFrom(superVertex)) continue;
            return true;
        }
        return false;
    }

    default public boolean isInstanceOf(T metaVertex) {
        return ((DefaultGeneric)this.getMeta()).inheritsFrom(metaVertex);
    }

    default public boolean isSpecializationOf(T supra) {
        return this.getLevel() == supra.getLevel() ? this.inheritsFrom(supra) : this.getLevel() > supra.getLevel() && ((DefaultGeneric)this.getMeta()).isSpecializationOf(supra);
    }

    default public boolean isCompositeOf(T vertex) {
        return this.getComponents().stream().anyMatch(component -> vertex.isSpecializationOf((Object)component));
    }

    default public boolean isCompositeForInstances(T vertex) {
        return this.getComponents().stream().anyMatch(component -> vertex.inheritsFrom((Object)component));
    }

    default public T getComponent(int pos) {
        return (T)(pos >= 0 && pos < this.getComponents().size() ? (DefaultGeneric)this.getComponents().get(pos) : null);
    }

    default public T getBaseComponent() {
        return (T)this.getComponent(0);
    }

    default public T getTargetComponent() {
        return (T)this.getComponent(1);
    }

    default public T getTernaryComponent() {
        return (T)this.getComponent(2);
    }
}

