/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults.tools;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.disposables.Disposables;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public class RxJavaHelpers {
    public static <T> Observable<T> valuesOf(ObservableValue<T> fxObservable) {
        return RxJavaHelpers.fromObservableValue(fxObservable);
    }

    public static <T> Observable<Optional<T>> optionalValuesOf(ObservableValue<T> fxObservable) {
        return RxJavaHelpers.fromNullableObservableValue(fxObservable);
    }

    public static <T> Observable<List<T>> changesOf(ObservableList<T> source) {
        return RxJavaHelpers.fromObservableList(source);
    }

    public static <T> Observable<T> additionsOf(ObservableList<T> source) {
        return RxJavaHelpers.fromObservableListAdds(source);
    }

    public static <T> Observable<T> removalsOf(ObservableList<T> source) {
        return RxJavaHelpers.fromObservableListRemovals(source);
    }

    public static <K, T> Observable<Map<K, T>> changesOf(ObservableMap<K, T> source) {
        return RxJavaHelpers.fromObservableMap(source);
    }

    public static <K, T> Observable<Map.Entry<K, T>> additionsOf(ObservableMap<K, T> source) {
        return RxJavaHelpers.fromObservableMapAdds(source);
    }

    public static <K, T> Observable<Map.Entry<K, T>> removalsOf(ObservableMap<K, T> source) {
        return RxJavaHelpers.fromObservableMapRemovals(source);
    }

    private static <T> Observable<T> fromObservableValue(ObservableValue<T> fxObservable) {
        return Observable.create(emitter -> {
            if (fxObservable.getValue() != null) {
                emitter.onNext(fxObservable.getValue());
            }
            ChangeListener listener = (observableValue, prev, current) -> {
                if (current != null) {
                    emitter.onNext(current);
                }
            };
            fxObservable.addListener(listener);
            emitter.setDisposable(Disposables.fromRunnable(() -> fxObservable.removeListener(listener)));
        });
    }

    public static <T> Observable<T> prevFromObservableValue(ObservableValue<T> fxObservable) {
        return Observable.create(emitter -> {
            ChangeListener listener = (observableValue, prev, current) -> {
                if (prev != null) {
                    emitter.onNext(prev);
                }
            };
            fxObservable.addListener(listener);
            emitter.setDisposable(Disposables.fromRunnable(() -> fxObservable.removeListener(listener)));
        });
    }

    private static <T> Observable<Optional<T>> fromNullableObservableValue(ObservableValue<T> fxObservable) {
        return Observable.create(emitter -> {
            emitter.onNext(Optional.ofNullable(fxObservable.getValue()));
            ChangeListener listener = (observableValue, prev, current) -> emitter.onNext(Optional.ofNullable(current));
            fxObservable.addListener(listener);
            emitter.setDisposable(Disposables.fromRunnable(() -> fxObservable.removeListener(listener)));
        });
    }

    private static <T> Observable<List<T>> fromObservableList(ObservableList<T> source) {
        return Observable.create(subscriber -> {
            ListChangeListener listener = c -> subscriber.onNext((Object)source);
            source.addListener(listener);
            subscriber.setDisposable(Disposables.fromRunnable(() -> source.removeListener(listener)));
        }).startWith(source);
    }

    private static <T> Observable<T> fromObservableListAdds(ObservableList<T> source) {
        return Observable.create(subscriber -> {
            ListChangeListener listener = c -> {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    c.getAddedSubList().forEach(arg_0 -> ((ObservableEmitter)subscriber).onNext(arg_0));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(Disposables.fromRunnable(() -> source.removeListener(listener)));
        });
    }

    private static <T> Observable<T> fromObservableListRemovals(ObservableList<T> source) {
        return Observable.create(subscriber -> {
            ListChangeListener listener = c -> {
                while (c.next()) {
                    if (!c.wasRemoved()) continue;
                    c.getRemoved().forEach(arg_0 -> ((ObservableEmitter)subscriber).onNext(arg_0));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(Disposables.fromRunnable(() -> source.removeListener(listener)));
        });
    }

    private static <K, T> Observable<Map<K, T>> fromObservableMap(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> subscriber.onNext((Object)source);
            source.addListener(listener);
            subscriber.setDisposable(Disposables.fromRunnable(() -> source.removeListener(listener)));
        }).startWith(source);
    }

    private static <K, T> Observable<Map.Entry<K, T>> fromObservableMapAdds(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasAdded()) {
                    subscriber.onNext(new AbstractMap.SimpleEntry<Object, Object>(c.getKey(), c.getValueAdded()));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(Disposables.fromRunnable(() -> source.removeListener(listener)));
        });
    }

    private static <K, T> Observable<Map.Entry<K, T>> fromObservableMapRemovals(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new AbstractMap.SimpleEntry<Object, Object>(c.getKey(), c.getValueRemoved()));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(Disposables.fromRunnable(() -> source.removeListener(listener)));
        });
    }
}

