/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.defaults.tools;

import com.sun.javafx.collections.ObservableListWrapper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.util.Callback;

public class TransformationObservableList<SOURCE, TARGET>
extends ObservableListWrapper<TARGET>
implements ListChangeListener<SOURCE> {
    private final BiConsumer<Integer, SOURCE> addBiConsumer;
    private final ObservableList<SOURCE> external;
    private final Consumer<Integer> removeConsumer;
    private BindingHelperObserver<SOURCE> observer;

    public final void bind() {
        if (this.observer == null) {
            this.observer = new BindingHelperObserver(this);
        }
        this.external.addListener(this.observer);
    }

    public final void unbind() {
        if (this.observer != null) {
            this.external.removeListener(this.observer);
        }
        this.observer = null;
    }

    public BiConsumer<Integer, SOURCE> getAddBiConsumer() {
        return this.addBiConsumer;
    }

    public Consumer<Integer> getRemoveConsumer() {
        return this.removeConsumer;
    }

    public TransformationObservableList(ObservableList<SOURCE> external, Function<SOURCE, TARGET> srcToTarget) {
        super(new ArrayList());
        this.external = external;
        this.addBiConsumer = (index, src) -> this.add((int)index, srcToTarget.apply(src));
        this.removeConsumer = index -> this.remove((int)index);
        this.bind();
        this.init();
    }

    public void init() {
        int i = 0;
        this.beginChange();
        for (Object element : this.external) {
            this.getAddBiConsumer().accept(i++, element);
        }
        this.endChange();
    }

    public TransformationObservableList(ObservableList<SOURCE> external, Function<SOURCE, TARGET> srcToTarget, Callback<TARGET, Observable[]> extractor) {
        super(new ArrayList(), extractor);
        this.external = external;
        this.addBiConsumer = (index, src) -> this.add((int)index, srcToTarget.apply(src));
        this.removeConsumer = index -> this.remove((int)index);
        this.bind();
        this.init();
    }

    public TransformationObservableList(ObservableList<SOURCE> external, BiFunction<Integer, SOURCE, TARGET> add, Consumer<TARGET> consumer) {
        super(new ArrayList());
        this.external = external;
        this.addBiConsumer = (index, src) -> this.add((int)index, add.apply((Integer)index, (SOURCE)src));
        this.removeConsumer = index -> consumer.accept(this.remove((int)index));
        this.bind();
        this.init();
    }

    public TransformationObservableList(ObservableList<SOURCE> external, BiFunction<Integer, SOURCE, TARGET> add, Consumer<TARGET> consumer, Callback<TARGET, Observable[]> extractor) {
        super(new ArrayList(), extractor);
        this.external = external;
        this.addBiConsumer = (index, src) -> this.add((int)index, add.apply((Integer)index, (SOURCE)src));
        this.removeConsumer = index -> consumer.accept(this.remove((int)index));
        this.bind();
        this.init();
    }

    public TransformationObservableList(ObservableList<SOURCE> external, BiFunction<Integer, SOURCE, TARGET> add) {
        super(new ArrayList());
        this.external = external;
        this.addBiConsumer = (index, src) -> this.add((int)index, add.apply((Integer)index, (SOURCE)src));
        this.removeConsumer = index -> this.remove((int)index);
        this.bind();
    }

    public void onChanged(ListChangeListener.Change<? extends SOURCE> change) {
        while (change.next()) {
            int index;
            int i;
            this.beginChange();
            if (change.wasPermutated()) {
                assert (false);
                for (i = change.getFrom(); i < change.getTo(); ++i) {
                    this.getRemoveConsumer().accept(change.getFrom());
                }
                index = change.getFrom();
                for (Object source : change.getList().subList(change.getFrom(), change.getTo())) {
                    this.getAddBiConsumer().accept(index++, source);
                }
            } else {
                if (change.wasRemoved()) {
                    for (i = 0; i < change.getRemovedSize(); ++i) {
                        this.getRemoveConsumer().accept(change.getFrom());
                    }
                }
                if (change.wasAdded()) {
                    index = change.getFrom();
                    for (Object source : change.getAddedSubList()) {
                        this.getAddBiConsumer().accept(index++, source);
                    }
                }
            }
            this.endChange();
        }
    }

    public static class BindingHelperObserver<E>
    implements ListChangeListener<E> {
        private final WeakReference<TransformationObservableList<E, ?>> ref;

        public BindingHelperObserver(TransformationObservableList<E, ?> transformationList) {
            if (transformationList == null) {
                throw new NullPointerException("Binding has to be specified.");
            }
            this.ref = new WeakReference(transformationList);
        }

        public void onChanged(ListChangeListener.Change<? extends E> change) {
            TransformationObservableList binding = (TransformationObservableList)((Object)this.ref.get());
            if (binding == null) {
                change.getList().removeListener((ListChangeListener)this);
            } else {
                binding.onChanged(change);
            }
        }
    }
}

